/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import io.github.ladysnake.pal.PlayerAbility;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class PlayerAbilityPower
extends Power {
    private final PlayerAbility ability;
    private final AbilitySource source;

    public PlayerAbilityPower(PowerType<?> type, class_1309 entity, PlayerAbility playerAbility) {
        super(type, entity);
        this.ability = playerAbility;
        if (entity instanceof class_1657) {
            this.setTicking(true);
        }
        this.source = Pal.getAbilitySource((class_2960)type.getIdentifier());
    }

    @Override
    public void tick() {
        if (!this.entity.method_37908().field_9236) {
            boolean isActive = this.isActive();
            boolean hasAbility = this.hasAbility();
            if (isActive && !hasAbility) {
                this.grantAbility();
            } else if (!isActive && hasAbility) {
                this.revokeAbility();
            }
        }
    }

    @Override
    public void onGained() {
        if (!this.entity.method_37908().field_9236 && this.entity instanceof class_1657 && this.isActive() && !this.hasAbility()) {
            this.grantAbility();
        }
    }

    @Override
    public void onAdded() {
        class_1657 player;
        class_1309 class_13092;
        if (!this.entity.method_37908().field_9236 && (class_13092 = this.entity) instanceof class_1657 && Apoli.LEGACY_POWER_SOURCE.grants(player = (class_1657)class_13092, this.ability)) {
            Apoli.LEGACY_POWER_SOURCE.revokeFrom(player, this.ability);
        }
    }

    @Override
    public void onLost() {
        if (!this.entity.method_37908().field_9236 && this.entity instanceof class_1657 && this.hasAbility()) {
            this.revokeAbility();
        }
    }

    public boolean hasAbility() {
        return this.source.grants((class_1657)this.entity, this.ability);
    }

    public void grantAbility() {
        this.source.grantTo((class_1657)this.entity, this.ability);
    }

    public void revokeAbility() {
        this.source.revokeFrom((class_1657)this.entity, this.ability);
    }

    public static PowerFactory createAbilityFactory(class_2960 identifier, PlayerAbility ability) {
        return new PowerFactory(identifier, new SerializableData(), data -> (type, player) -> new PlayerAbilityPower((PowerType<?>)type, (class_1309)player, ability)).allowCondition();
    }
}

