/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2694;
import net.minecraft.class_4538;

public class PhasingPower
extends Power {
    private final Predicate<class_2694> blocks;
    private final boolean isBlacklist;
    private final Predicate<class_1297> phaseDownCondition;
    private final RenderType renderType;
    private final float viewDistance;

    public PhasingPower(PowerType<?> type, class_1309 entity, Predicate<class_2694> blocks, boolean isBlacklist, RenderType renderType, float viewDistance, Predicate<class_1297> phaseDownCondition) {
        super(type, entity);
        this.blocks = blocks;
        this.isBlacklist = isBlacklist;
        this.renderType = renderType;
        this.viewDistance = viewDistance;
        this.phaseDownCondition = phaseDownCondition;
    }

    public boolean doesApply(class_2338 pos) {
        return this.isBlacklist != this.blocks.test(new class_2694((class_4538)this.entity.method_37908(), pos, true));
    }

    public boolean shouldPhaseDown(class_1297 entity) {
        return this.phaseDownCondition == null ? entity.method_5715() : this.phaseDownCondition.test(entity);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public float getViewDistance() {
        return this.viewDistance;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("phasing"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("blacklist", SerializableDataTypes.BOOLEAN, (Object)false).add("render_type", SerializableDataType.enumValue(RenderType.class), (Object)RenderType.BLINDNESS).add("view_distance", SerializableDataTypes.FLOAT, (Object)Float.valueOf(10.0f)).add("phase_down_condition", ApoliDataTypes.ENTITY_CONDITION, null), data -> (type, player) -> new PhasingPower((PowerType<?>)type, (class_1309)player, data.isPresent("block_condition") ? (Predicate)data.get("block_condition") : cbp -> true, data.getBoolean("blacklist"), (RenderType)((Object)((Object)((Object)data.get("render_type")))), data.getFloat("view_distance"), (Predicate)data.get("phase_down_condition"))).allowCondition();
    }

    public static enum RenderType {
        BLINDNESS,
        REMOVE_BLOCKS,
        NONE;

    }
}

