/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_757;

public class OverlayPower
extends Power {
    private final class_2960 texture;
    private final float strength;
    private final float red;
    private final float green;
    private final float blue;
    private final DrawMode drawMode;
    private final DrawPhase drawPhase;
    private final boolean hideWithHud;
    private final boolean visibleInThirdPerson;

    public OverlayPower(PowerType<?> type, class_1309 entity, class_2960 texture, float strength, float red, float green, float blue, DrawMode drawMode, DrawPhase drawPhase, boolean hideWithHud, boolean visibleInThirdPerson) {
        super(type, entity);
        this.texture = texture;
        this.strength = strength;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.drawMode = drawMode;
        this.drawPhase = drawPhase;
        this.hideWithHud = hideWithHud;
        this.visibleInThirdPerson = visibleInThirdPerson;
    }

    public DrawPhase getDrawPhase() {
        return this.drawPhase;
    }

    public boolean shouldBeVisibleInThirdPerson() {
        return this.visibleInThirdPerson;
    }

    public boolean doesHideWithHud() {
        return this.hideWithHud;
    }

    @Environment(value=EnvType.CLIENT)
    public void render() {
        float a;
        double n;
        double m;
        double l;
        double e;
        float k;
        float h;
        float g;
        class_310 client = class_310.method_1551();
        int i = client.method_22683().method_4486();
        int j = client.method_22683().method_4502();
        switch (this.drawMode.ordinal()) {
            case 0: {
                double d = class_3532.method_16436((double)this.strength, (double)2.0, (double)1.0);
                g = this.red * this.strength;
                h = this.green * this.strength;
                k = this.blue * this.strength;
                e = (double)i * d;
                l = (double)j * d;
                m = ((double)i - e) / 2.0;
                n = ((double)j - l) / 2.0;
                a = 1.0f;
                break;
            }
            default: {
                g = this.red;
                h = this.green;
                k = this.blue;
                a = this.strength;
                e = i;
                l = j;
                m = 0.0;
                n = 0.0;
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        switch (this.drawMode.ordinal()) {
            case 0: {
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                break;
            }
            default: {
                RenderSystem.defaultBlendFunc();
            }
        }
        RenderSystem.setShaderColor((float)g, (float)h, (float)k, (float)a);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22912(m, n + l, -90.0).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(m + e, n + l, -90.0).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(m + e, n, -90.0).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22912(m, n, -90.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("overlay"), new SerializableData().add("texture", SerializableDataTypes.IDENTIFIER).add("strength", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("red", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("green", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("blue", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("draw_mode", SerializableDataType.enumValue(DrawMode.class)).add("draw_phase", SerializableDataType.enumValue(DrawPhase.class)).add("hide_with_hud", SerializableDataTypes.BOOLEAN, (Object)true).add("visible_in_third_person", SerializableDataTypes.BOOLEAN, (Object)false), data -> (type, player) -> new OverlayPower((PowerType<?>)type, (class_1309)player, data.getId("texture"), data.getFloat("strength"), data.getFloat("red"), data.getFloat("green"), data.getFloat("blue"), (DrawMode)((Object)((Object)((Object)data.get("draw_mode")))), (DrawPhase)((Object)((Object)((Object)data.get("draw_phase")))), data.getBoolean("hide_with_hud"), data.getBoolean("visible_in_third_person"))).allowCondition();
    }

    public static enum DrawMode {
        NAUSEA,
        TEXTURE;

    }

    public static enum DrawPhase {
        BELOW_HUD,
        ABOVE_HUD;

    }
}

