/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;

public class ModifyProjectileDamagePower
extends ValueModifyingPower {
    private final Predicate<class_3545<class_1282, Float>> condition;
    private final Predicate<class_1297> targetCondition;
    private Consumer<class_1297> targetAction;
    private Consumer<class_1297> selfAction;

    public ModifyProjectileDamagePower(PowerType<?> type, class_1309 entity, Predicate<class_3545<class_1282, Float>> condition, Predicate<class_1297> targetCondition) {
        super(type, entity);
        this.condition = condition;
        this.targetCondition = targetCondition;
    }

    public boolean doesApply(class_1282 source, float damageAmount, class_1309 target) {
        return this.condition.test((class_3545<class_1282, Float>)new class_3545((Object)source, (Object)Float.valueOf(damageAmount))) && (target == null || this.targetCondition == null || this.targetCondition.test((class_1297)target));
    }

    public void setTargetAction(Consumer<class_1297> targetAction) {
        this.targetAction = targetAction;
    }

    public void setSelfAction(Consumer<class_1297> selfAction) {
        this.selfAction = selfAction;
    }

    public void executeActions(class_1297 target) {
        if (this.selfAction != null) {
            this.selfAction.accept((class_1297)this.entity);
        }
        if (this.targetAction != null) {
            this.targetAction.accept(target);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_projectile_damage"), new SerializableData().add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null).add("target_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("self_action", ApoliDataTypes.ENTITY_ACTION, null).add("target_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> {
            ModifyProjectileDamagePower power = new ModifyProjectileDamagePower((PowerType<?>)type, (class_1309)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("target_condition"));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("target_action")) {
                power.setTargetAction((Consumer)data.get("target_action"));
            }
            return power;
        }).allowCondition();
    }
}

