/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2694;
import net.minecraft.class_3545;
import net.minecraft.class_4538;
import org.apache.commons.lang3.tuple.Triple;

public class ModifyGrindstonePower
extends Power {
    private final Predicate<class_1799> topItemCondition;
    private final Predicate<class_1799> bottomItemCondition;
    private final Predicate<class_1799> outputItemCondition;
    private final Predicate<class_2694> blockCondition;
    private final class_1799 newResultStack;
    private final Consumer<class_3545<class_1937, class_1799>> resultItemAction;
    private final Consumer<class_3545<class_1937, class_1799>> lateItemAction;
    private final Consumer<class_1297> entityAction;
    private final Consumer<Triple<class_1937, class_2338, class_2350>> blockAction;
    private final ResultType resultType;
    private final Modifier experienceModifier;

    public ModifyGrindstonePower(PowerType<?> type, class_1309 entity, Predicate<class_1799> topItemCondition, Predicate<class_1799> bottomItemCondition, Predicate<class_1799> outputItemCondition, Predicate<class_2694> blockCondition, class_1799 newResultStack, Consumer<class_3545<class_1937, class_1799>> resultItemAction, Consumer<class_3545<class_1937, class_1799>> lateItemAction, Consumer<class_1297> entityAction, Consumer<Triple<class_1937, class_2338, class_2350>> blockAction, ResultType resultType, Modifier experienceModifier) {
        super(type, entity);
        this.topItemCondition = topItemCondition;
        this.bottomItemCondition = bottomItemCondition;
        this.outputItemCondition = outputItemCondition;
        this.blockCondition = blockCondition;
        this.newResultStack = newResultStack;
        this.resultItemAction = resultItemAction;
        this.lateItemAction = lateItemAction;
        this.entityAction = entityAction;
        this.blockAction = blockAction;
        this.resultType = resultType;
        this.experienceModifier = experienceModifier;
    }

    public boolean allowsInTop(class_1799 inputTop) {
        return this.topItemCondition == null || this.topItemCondition.test(inputTop);
    }

    public boolean allowsInBottom(class_1799 inputBottom) {
        return this.bottomItemCondition == null || this.bottomItemCondition.test(inputBottom);
    }

    public void applyAfterGrindingItemAction(class_1799 output) {
        if (this.lateItemAction == null) {
            return;
        }
        this.lateItemAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)output));
    }

    public boolean doesApply(class_1799 inputTop, class_1799 inputBottom, class_1799 originalOutput, Optional<class_2338> grindstonePos) {
        if (this.topItemCondition != null && !this.topItemCondition.test(inputTop)) {
            return false;
        }
        if (this.bottomItemCondition != null && !this.bottomItemCondition.test(inputBottom)) {
            return false;
        }
        if (this.outputItemCondition != null && !this.outputItemCondition.test(originalOutput)) {
            return false;
        }
        return this.blockCondition == null || !grindstonePos.isPresent() || this.blockCondition.test(new class_2694((class_4538)this.entity.method_37908(), grindstonePos.get(), true));
    }

    public Modifier getExperienceModifier() {
        return this.experienceModifier;
    }

    public class_1799 getOutput(class_1799 inputTop, class_1799 inputBottom, class_1799 currentOutput) {
        class_1799 output = currentOutput.method_7972();
        switch (this.resultType.ordinal()) {
            case 1: {
                output = this.newResultStack.method_7972();
                break;
            }
            case 3: {
                output = inputBottom.method_7972();
                break;
            }
            case 2: {
                output = inputTop.method_7972();
            }
        }
        if (this.resultItemAction != null) {
            this.resultItemAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)output));
        }
        return output;
    }

    public void executeActions(Optional<class_2338> pos) {
        if (this.entityAction != null) {
            this.entityAction.accept((class_1297)this.entity);
        }
        if (this.blockAction != null && pos.isPresent()) {
            this.blockAction.accept((Triple<class_1937, class_2338, class_2350>)Triple.of((Object)this.entity.method_37908(), (Object)pos.get(), (Object)class_2350.field_11036));
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_grindstone"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("block_action", ApoliDataTypes.BLOCK_ACTION, null).add("top_condition", ApoliDataTypes.ITEM_CONDITION, null).add("bottom_condition", ApoliDataTypes.ITEM_CONDITION, null).add("output_condition", ApoliDataTypes.ITEM_CONDITION, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("item_action_after_grinding", ApoliDataTypes.ITEM_ACTION, null).add("result_stack", SerializableDataTypes.ITEM_STACK, null).add("result_type", SerializableDataType.enumValue(ResultType.class), (Object)ResultType.UNCHANGED).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("xp_modifier", Modifier.DATA_TYPE, null), data -> (type, player) -> new ModifyGrindstonePower((PowerType<?>)type, (class_1309)player, (Predicate)data.get("top_condition"), (Predicate)data.get("bottom_condition"), (Predicate)data.get("output_condition"), (Predicate)data.get("block_condition"), (class_1799)data.get("result_stack"), (Consumer)data.get("item_action"), (Consumer)data.get("item_action_after_grinding"), (Consumer)data.get("entity_action"), (Consumer)data.get("block_action"), (ResultType)((Object)((Object)((Object)data.get("result_type")))), (Modifier)data.get("xp_modifier")));
    }

    private static enum ResultType {
        UNCHANGED,
        SPECIFIED,
        FROM_TOP,
        FROM_BOTTOM;

    }
}

