/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;

public class ModifyDamageTakenPower
extends ValueModifyingPower {
    private final Predicate<class_3545<class_1282, Float>> condition;
    private final Predicate<class_3545<class_1297, class_1297>> biEntityCondition;
    private Consumer<class_1297> attackerAction;
    private Consumer<class_1297> selfAction;
    private Consumer<class_3545<class_1297, class_1297>> biEntityAction;
    private Predicate<class_1297> applyArmorCondition;
    private Predicate<class_1297> damageArmorCondition;

    public ModifyDamageTakenPower(PowerType<?> type, class_1309 entity, Predicate<class_3545<class_1282, Float>> condition, Predicate<class_3545<class_1297, class_1297>> biEntityCondition) {
        super(type, entity);
        this.condition = condition;
        this.biEntityCondition = biEntityCondition;
    }

    public void setApplyArmorCondition(Predicate<class_1297> applyArmorCondition) {
        this.applyArmorCondition = applyArmorCondition;
    }

    public void setDamageArmorCondition(Predicate<class_1297> damageArmorCondition) {
        this.damageArmorCondition = damageArmorCondition;
    }

    public boolean modifiesArmorApplicance() {
        return this.applyArmorCondition != null;
    }

    public boolean shouldApplyArmor() {
        return this.applyArmorCondition != null && this.applyArmorCondition.test((class_1297)this.entity);
    }

    public boolean modifiesArmorDamaging() {
        return this.damageArmorCondition != null;
    }

    public boolean shouldDamageArmor() {
        return this.damageArmorCondition != null && this.damageArmorCondition.test((class_1297)this.entity);
    }

    public boolean doesApply(class_1282 source, float damageAmount) {
        return source.method_5529() == null ? this.condition.test((class_3545<class_1282, Float>)new class_3545((Object)source, (Object)Float.valueOf(damageAmount))) && this.biEntityCondition == null : this.condition.test((class_3545<class_1282, Float>)new class_3545((Object)source, (Object)Float.valueOf(damageAmount))) && (this.biEntityCondition == null || this.biEntityCondition.test((class_3545<class_1297, class_1297>)new class_3545((Object)source.method_5529(), (Object)this.entity)));
    }

    public void setAttackerAction(Consumer<class_1297> attackerAction) {
        this.attackerAction = attackerAction;
    }

    public void setSelfAction(Consumer<class_1297> selfAction) {
        this.selfAction = selfAction;
    }

    public void setBiEntityAction(Consumer<class_3545<class_1297, class_1297>> biEntityAction) {
        this.biEntityAction = biEntityAction;
    }

    public void executeActions(class_1297 attacker) {
        if (this.selfAction != null) {
            this.selfAction.accept((class_1297)this.entity);
        }
        if (this.attackerAction != null) {
            this.attackerAction.accept(attacker);
        }
        if (this.biEntityAction != null) {
            this.biEntityAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)attacker, (Object)this.entity));
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_damage_taken"), new SerializableData().add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null).add("self_action", ApoliDataTypes.ENTITY_ACTION, null).add("attacker_action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("apply_armor_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("damage_armor_condition", ApoliDataTypes.ENTITY_CONDITION, null), data -> (type, player) -> {
            ModifyDamageTakenPower power = new ModifyDamageTakenPower((PowerType<?>)type, (class_1309)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("bientity_condition"));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            if (data.isPresent("bientity_action")) {
                power.setBiEntityAction((Consumer)data.get("bientity_action"));
            }
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("attacker_action")) {
                power.setAttackerAction((Consumer)data.get("attacker_action"));
            }
            data.ifPresent("apply_armor_condition", power::setApplyArmorCondition);
            data.ifPresent("damage_armor_condition", power::setDamageArmorCondition);
            return power;
        }).allowCondition();
    }
}

