/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public class KeepInventoryPower
extends Power {
    private final Predicate<class_1799> keepItemCondition;
    private final Set<Integer> slots;
    private class_1799[] savedStacks;

    public KeepInventoryPower(PowerType<?> type, class_1309 entity, Predicate<class_1799> keepItemCondition, Collection<Integer> slots) {
        super(type, entity);
        this.keepItemCondition = keepItemCondition;
        this.slots = slots == null ? null : new HashSet<Integer>(slots);
    }

    public void preventItemsFromDropping(class_1263 inventory) {
        this.savedStacks = new class_1799[inventory.method_5439()];
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack;
            if (this.slots != null && !this.slots.contains(i) || (stack = inventory.method_5438(i)).method_7960() || this.keepItemCondition != null && !this.keepItemCondition.test(stack)) continue;
            this.savedStacks[i] = stack;
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    public void restoreSavedItems(class_1263 inventory) {
        if (this.savedStacks == null) {
            Apoli.LOGGER.error(KeepInventoryPower.class.getSimpleName() + ": Tried to restore items without having saved any on entity \"" + this.entity.method_5477().getString() + "\". Power may not have functioned correctly.");
            return;
        }
        if (inventory.method_5439() != this.savedStacks.length) {
            Apoli.LOGGER.error(KeepInventoryPower.class.getSimpleName() + ": Tried to restore items with differently sized inventory on entity \"" + this.entity.method_5477().getString() + "\". Items may have been lost.");
        }
        for (int i = 0; i < inventory.method_5439() && i < this.savedStacks.length; ++i) {
            if (this.savedStacks[i] == null || this.savedStacks[i].method_7960()) continue;
            inventory.method_5447(i, this.savedStacks[i]);
        }
        this.savedStacks = null;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("keep_inventory"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("slots", SerializableDataTypes.INTS, null), data -> (type, player) -> new KeepInventoryPower((PowerType<?>)type, (class_1309)player, (Predicate)data.get("item_condition"), (Collection)data.get("slots"))).allowCondition();
    }
}

