/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1270;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1716;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_747;

public class InventoryPower
extends Power
implements Active,
class_1263 {
    private final class_2371<class_1799> container;
    private final class_5250 containerTitle;
    private final class_1270 containerScreen;
    private final Predicate<class_1799> dropOnDeathFilter;
    private final boolean shouldDropOnDeath;
    private final boolean recoverable;
    private final int containerSize;
    private Active.Key key;

    public InventoryPower(PowerType<?> type, class_1309 entity, String containerTitle, ContainerType containerType, boolean shouldDropOnDeath, Predicate<class_1799> dropOnDeathFilter, boolean recoverable) {
        super(type, entity);
        switch (containerType.ordinal()) {
            case 1: {
                this.containerSize = 54;
                this.containerScreen = (i, playerInventory, playerEntity) -> new class_1707(class_3917.field_17327, i, playerInventory, (class_1263)this, 6);
                break;
            }
            case 0: {
                this.containerSize = 27;
                this.containerScreen = (i, playerInventory, playerEntity) -> new class_1707(class_3917.field_17326, i, playerInventory, (class_1263)this, 3);
                break;
            }
            case 4: {
                this.containerSize = 5;
                this.containerScreen = (i, playerInventory, playerEntity) -> new class_1722(i, playerInventory, (class_1263)this);
                break;
            }
            default: {
                this.containerSize = 9;
                this.containerScreen = (i, playerInventory, playerEntity) -> new class_1716(i, playerInventory, (class_1263)this);
            }
        }
        this.container = class_2371.method_10213((int)this.containerSize, (Object)class_1799.field_8037);
        this.containerTitle = class_2561.method_43471((String)containerTitle);
        this.shouldDropOnDeath = shouldDropOnDeath;
        this.dropOnDeathFilter = dropOnDeathFilter;
        this.recoverable = recoverable;
    }

    @Override
    public void onLost() {
        if (this.recoverable) {
            this.dropItemsOnLost();
        }
    }

    @Override
    public void onUse() {
        class_1309 class_13092;
        if (!this.isActive()) {
            return;
        }
        if (!this.entity.method_37908().field_9236 && (class_13092 = this.entity) instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_13092;
            playerEntity.method_17355((class_3908)new class_747(this.containerScreen, (class_2561)this.containerTitle));
        }
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        class_1262.method_5426((class_2487)tag, this.container);
        return tag;
    }

    @Override
    public void fromTag(class_2520 tag) {
        class_1262.method_5429((class_2487)((class_2487)tag), this.container);
    }

    public int method_5439() {
        return this.containerSize;
    }

    public boolean method_5442() {
        return this.container.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.container.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return ((class_1799)this.container.get(slot)).method_7971(amount);
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = (class_1799)this.container.get(slot);
        this.method_5447(slot, class_1799.field_8037);
        return stack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.container.set(slot, (Object)stack);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return player == this.entity;
    }

    public void method_5448() {
        for (int i = 0; i < this.containerSize; ++i) {
            this.method_5447(i, class_1799.field_8037);
        }
    }

    public class_2371<class_1799> getContainer() {
        return this.container;
    }

    public class_5250 getContainerTitle() {
        return this.containerTitle;
    }

    public class_1270 getContainerScreen() {
        return this.containerScreen;
    }

    public boolean shouldDropOnDeath() {
        return this.shouldDropOnDeath;
    }

    public boolean shouldDropOnDeath(class_1799 stack) {
        return this.shouldDropOnDeath && this.dropOnDeathFilter.test(stack);
    }

    public void dropItemsOnDeath() {
        class_1657 playerEntity = (class_1657)this.entity;
        for (int i = 0; i < this.containerSize; ++i) {
            class_1799 currentItemStack = this.method_5438(i);
            if (!this.shouldDropOnDeath(currentItemStack)) continue;
            if (!currentItemStack.method_7960() && class_1890.method_8221((class_1799)currentItemStack)) {
                this.method_5441(i);
                continue;
            }
            playerEntity.method_7329(currentItemStack, true, false);
            this.method_5447(i, class_1799.field_8037);
        }
    }

    public void dropItemsOnLost() {
        class_1657 playerEntity = (class_1657)this.entity;
        for (int i = 0; i < this.containerSize; ++i) {
            class_1799 currentItemStack = this.method_5438(i);
            playerEntity.method_31548().method_7398(currentItemStack);
        }
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("inventory"), new SerializableData().add("title", SerializableDataTypes.STRING, (Object)"container.inventory").add("container_type", SerializableDataType.enumValue(ContainerType.class), (Object)ContainerType.DROPPER).add("drop_on_death", SerializableDataTypes.BOOLEAN, (Object)false).add("drop_on_death_filter", ApoliDataTypes.ITEM_CONDITION, null).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()).add("recoverable", SerializableDataTypes.BOOLEAN, (Object)true), data -> (powerType, livingEntity) -> {
            InventoryPower inventoryPower = new InventoryPower((PowerType<?>)powerType, (class_1309)livingEntity, data.getString("title"), (ContainerType)((Object)((Object)((Object)data.get("container_type")))), data.getBoolean("drop_on_death"), data.isPresent("drop_on_death_filter") ? (Predicate)data.get("drop_on_death_filter") : itemStack -> true, data.getBoolean("recoverable"));
            inventoryPower.setKey((Active.Key)data.get("key"));
            return inventoryPower;
        }).allowCondition();
    }

    public static enum ContainerType {
        CHEST,
        DOUBLE_CHEST,
        DROPPER,
        DISPENSER,
        HOPPER;

    }
}

