/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class FireProjectilePower
extends ActiveCooldownPower {
    private final class_1299<?> entityType;
    private final int projectileCount;
    private final int interval;
    private final int startDelay;
    private final float speed;
    private final float divergence;
    private final class_3414 soundEvent;
    private final class_2487 tag;
    private final Consumer<class_1297> projectileAction;
    private final Consumer<class_1297> shooterAction;
    private boolean isFiringProjectiles;
    private boolean finishedStartDelay;
    private int shotProjectiles;

    public FireProjectilePower(PowerType<?> type, class_1309 entity, int cooldownDuration, HudRender hudRender, class_1299<?> entityType, int projectileCount, int interval, int startDelay, float speed, float divergence, class_3414 soundEvent, class_2487 tag, Consumer<class_1297> projectileAction, Consumer<class_1297> shooterAction) {
        super(type, entity, cooldownDuration, hudRender, null);
        this.entityType = entityType;
        this.projectileCount = projectileCount;
        this.interval = interval;
        this.startDelay = startDelay;
        this.speed = speed;
        this.divergence = divergence;
        this.soundEvent = soundEvent;
        this.tag = tag;
        this.projectileAction = projectileAction;
        this.shooterAction = shooterAction;
        this.setTicking(true);
    }

    @Override
    public void onUse() {
        if (this.canUse()) {
            this.isFiringProjectiles = true;
            this.use();
        }
    }

    @Override
    public class_2520 toTag() {
        class_2487 nbt = new class_2487();
        nbt.method_10544("LastUseTime", this.lastUseTime);
        nbt.method_10569("ShotProjectiles", this.shotProjectiles);
        nbt.method_10556("FinishedStartDelay", this.finishedStartDelay);
        nbt.method_10556("IsFiringProjectiles", this.isFiringProjectiles);
        return nbt;
    }

    @Override
    public void fromTag(class_2520 tag) {
        if (tag instanceof class_2503) {
            this.lastUseTime = ((class_2503)tag).method_10699();
        } else {
            this.lastUseTime = ((class_2487)tag).method_10537("LastUseTime");
            this.shotProjectiles = ((class_2487)tag).method_10550("ShotProjectiles");
            this.finishedStartDelay = ((class_2487)tag).method_10577("FinishedStartDelay");
            this.isFiringProjectiles = ((class_2487)tag).method_10577("IsFiringProjectiles");
        }
    }

    @Override
    public void tick() {
        if (this.isFiringProjectiles) {
            if (!this.finishedStartDelay && this.startDelay == 0) {
                this.finishedStartDelay = true;
            }
            if (!this.finishedStartDelay && (this.entity.method_5770().method_8510() - this.lastUseTime) % (long)this.startDelay == 0L) {
                this.finishedStartDelay = true;
                ++this.shotProjectiles;
                if (this.shotProjectiles <= this.projectileCount) {
                    if (this.soundEvent != null) {
                        this.entity.method_37908().method_43128(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), this.soundEvent, class_3419.field_15254, 0.5f, 0.4f / (this.entity.method_6051().method_43057() * 0.4f + 0.8f));
                    }
                    if (!this.entity.method_37908().field_9236) {
                        this.fireProjectile();
                    }
                } else {
                    this.shotProjectiles = 0;
                    this.finishedStartDelay = false;
                    this.isFiringProjectiles = false;
                }
            } else if (this.interval == 0 && this.finishedStartDelay) {
                if (this.soundEvent != null) {
                    this.entity.method_37908().method_43128(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), this.soundEvent, class_3419.field_15254, 0.5f, 0.4f / (this.entity.method_6051().method_43057() * 0.4f + 0.8f));
                }
                if (!this.entity.method_37908().field_9236) {
                    while (this.shotProjectiles < this.projectileCount) {
                        this.fireProjectile();
                        ++this.shotProjectiles;
                    }
                }
                this.shotProjectiles = 0;
                this.finishedStartDelay = false;
                this.isFiringProjectiles = false;
            } else if (this.finishedStartDelay && (this.entity.method_5770().method_8510() - this.lastUseTime) % (long)this.interval == 0L) {
                ++this.shotProjectiles;
                if (this.shotProjectiles <= this.projectileCount) {
                    if (this.soundEvent != null) {
                        this.entity.method_37908().method_43128(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), this.soundEvent, class_3419.field_15254, 0.5f, 0.4f / (this.entity.method_6051().method_43057() * 0.4f + 0.8f));
                    }
                    if (!this.entity.method_37908().field_9236) {
                        this.fireProjectile();
                    }
                } else {
                    this.shotProjectiles = 0;
                    this.finishedStartDelay = false;
                    this.isFiringProjectiles = false;
                }
            }
        }
    }

    private void fireProjectile() {
        if (this.entityType == null || this.entity.method_37908().field_9236) {
            return;
        }
        class_3218 serverWorld = (class_3218)this.entity.method_37908();
        float yaw = this.entity.method_36454();
        float pitch = this.entity.method_36455();
        Optional<class_1297> opt$entityToSpawn = MiscUtil.getEntityWithPassengers((class_1937)serverWorld, this.entityType, this.tag, this.entity.method_19538().method_1031(0.0, (double)this.entity.method_18381(this.entity.method_18376()), 0.0), yaw, pitch);
        if (opt$entityToSpawn.isEmpty()) {
            return;
        }
        class_243 rotationVector = this.entity.method_5720();
        class_243 velocity = this.entity.method_18798();
        class_1297 entityToSpawn = opt$entityToSpawn.get();
        class_5819 random = serverWorld.method_8409();
        if (entityToSpawn instanceof class_1676) {
            class_1676 projectileToSpawn = (class_1676)entityToSpawn;
            if (projectileToSpawn instanceof class_1668) {
                class_1668 explosiveProjectileToSpawn = (class_1668)projectileToSpawn;
                explosiveProjectileToSpawn.field_7601 = rotationVector.field_1352 * (double)this.speed;
                explosiveProjectileToSpawn.field_7600 = rotationVector.field_1351 * (double)this.speed;
                explosiveProjectileToSpawn.field_7599 = rotationVector.field_1350 * (double)this.speed;
            }
            projectileToSpawn.method_7432((class_1297)this.entity);
            projectileToSpawn.method_24919((class_1297)this.entity, pitch, yaw, 0.0f, this.speed, this.divergence);
        } else {
            float f = (float)Math.PI / 180;
            double g = 0.0075f;
            float h = -class_3532.method_15374((float)(yaw * f)) * class_3532.method_15362((float)(pitch * f));
            float i = -class_3532.method_15374((float)(pitch * f));
            float j = class_3532.method_15362((float)(yaw * f)) * class_3532.method_15362((float)(pitch * f));
            class_243 vec3d = new class_243((double)h, (double)i, (double)j).method_1029().method_1031(random.method_43059() * g * (double)this.divergence, random.method_43059() * g * (double)this.divergence, random.method_43059() * g * (double)this.divergence).method_1021((double)this.speed);
            entityToSpawn.method_18799(vec3d);
            entityToSpawn.method_5762(velocity.field_1352, this.entity.method_24828() ? 0.0 : velocity.field_1351, velocity.field_1350);
        }
        serverWorld.method_30736(entityToSpawn);
        if (this.projectileAction != null) {
            this.projectileAction.accept(entityToSpawn);
        }
        if (this.shooterAction != null) {
            this.shooterAction.accept((class_1297)this.entity);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("fire_projectile"), new SerializableData().add("cooldown", SerializableDataTypes.INT, (Object)1).add("count", SerializableDataTypes.INT, (Object)1).add("interval", SerializableDataTypes.INT, (Object)0).add("start_delay", SerializableDataTypes.INT, (Object)0).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("entity_type", SerializableDataTypes.ENTITY_TYPE).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("tag", SerializableDataTypes.NBT, null).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()).add("projectile_action", ApoliDataTypes.ENTITY_ACTION, null).add("shooter_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (powerType, livingEntity) -> {
            FireProjectilePower fpp = new FireProjectilePower((PowerType<?>)powerType, (class_1309)livingEntity, (Integer)data.get("cooldown"), (HudRender)data.get("hud_render"), (class_1299<?>)((class_1299)data.get("entity_type")), (Integer)data.get("count"), (Integer)data.get("interval"), (Integer)data.get("start_delay"), ((Float)data.get("speed")).floatValue(), ((Float)data.get("divergence")).floatValue(), (class_3414)data.get("sound"), (class_2487)data.get("tag"), (Consumer)data.get("projectile_action"), (Consumer)data.get("shooter_action"));
            fpp.setKey((Active.Key)data.get("key"));
            return fpp;
        }).allowCondition();
    }
}

