/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8109;
import net.minecraft.class_8110;

public class DamageOverTimePower
extends Power {
    public static final class_5321<class_8110> GENERIC_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)Apoli.identifier("damage_over_time"));
    private final int damageTickInterval;
    private final int beginDamageIn;
    private final float damageAmountEasy;
    private final float damageAmount;
    private final DamageSourceDescription damageSourceDescription;
    private final class_5321<class_8110> damageType;
    private final class_1887 protectingEnchantment;
    private final float protectionEffectiveness;
    private int outOfDamageTicks;
    private int inDamageTicks;
    private class_1282 damageSource;

    public DamageOverTimePower(PowerType<?> type, class_1309 entity, int beginDamageIn, int damageInterval, float damageAmountEasy, float damageAmount, DamageSourceDescription damageSourceDescription, class_5321<class_8110> damageType, class_1887 protectingEnchantment, float protectionEffectiveness) {
        super(type, entity);
        this.damageSourceDescription = damageSourceDescription;
        this.damageType = damageType;
        this.beginDamageIn = beginDamageIn;
        this.damageAmount = damageAmount;
        this.damageAmountEasy = damageAmountEasy;
        this.damageTickInterval = damageInterval;
        this.protectingEnchantment = protectingEnchantment;
        this.protectionEffectiveness = protectionEffectiveness;
        this.setTicking(true);
    }

    public int getDamageBegin() {
        int prot = this.getProtection();
        int delay = (int)(Math.pow(prot * 2, 1.3) * (double)this.protectionEffectiveness);
        return this.beginDamageIn + delay * 20;
    }

    @Override
    public void tick() {
        if (this.isActive()) {
            this.doDamage();
        } else {
            this.resetDamage();
        }
    }

    public void doDamage() {
        this.outOfDamageTicks = 0;
        if (this.inDamageTicks - this.getDamageBegin() >= 0 && (this.inDamageTicks - this.getDamageBegin()) % this.damageTickInterval == 0) {
            class_1282 source = this.getDamageSource(this.entity.method_48923());
            this.entity.method_5643(source, this.entity.method_37908().method_8407() == class_1267.field_5805 ? this.damageAmountEasy : this.damageAmount);
        }
        ++this.inDamageTicks;
    }

    private class_1282 getDamageSource(class_8109 damageSources) {
        if (this.damageSource == null) {
            this.damageSource = MiscUtil.createDamageSource(damageSources, this.damageSourceDescription, this.damageType);
        }
        return this.damageSource;
    }

    public void resetDamage() {
        if (this.outOfDamageTicks >= 20) {
            this.inDamageTicks = 0;
        } else {
            ++this.outOfDamageTicks;
        }
    }

    @Override
    public void onRespawn() {
        this.inDamageTicks = 0;
        this.outOfDamageTicks = 0;
    }

    private int getProtection() {
        if (this.protectingEnchantment == null) {
            return 0;
        }
        Map enchantedItems = this.protectingEnchantment.method_8185(this.entity);
        Collection iterable = enchantedItems.values();
        int i = 0;
        int items = 0;
        for (class_1799 itemStack : iterable) {
            int enchLevel = class_1890.method_8225((class_1887)this.protectingEnchantment, (class_1799)itemStack);
            i += enchLevel;
            if (enchLevel <= 0) continue;
            ++items;
        }
        return i + items;
    }

    @Override
    public class_2520 toTag() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("InDamage", this.inDamageTicks);
        nbt.method_10569("OutDamage", this.outOfDamageTicks);
        return nbt;
    }

    @Override
    public void fromTag(class_2520 tag) {
        if (tag instanceof class_2487) {
            class_2487 nbt = (class_2487)tag;
            this.inDamageTicks = nbt.method_10550("InDamage");
            this.outOfDamageTicks = nbt.method_10550("OutDamage");
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("damage_over_time"), new SerializableData().add("interval", SerializableDataTypes.INT, (Object)20).addFunctionedDefault("onset_delay", SerializableDataTypes.INT, data -> data.getInt("interval")).add("damage", SerializableDataTypes.FLOAT).addFunctionedDefault("damage_easy", SerializableDataTypes.FLOAT, data -> Float.valueOf(data.getFloat("damage"))).add("damage_source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, GENERIC_DAMAGE).add("protection_enchantment", SerializableDataTypes.ENCHANTMENT, null).add("protection_effectiveness", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)), data -> (type, player) -> new DamageOverTimePower((PowerType<?>)type, (class_1309)player, data.getInt("onset_delay"), data.getInt("interval"), data.getFloat("damage_easy"), data.getFloat("damage"), (DamageSourceDescription)data.get("damage_source"), (class_5321<class_8110>)((class_5321)data.get("damage_type")), (class_1887)data.get("protection_enchantment"), data.getFloat("protection_effectiveness"))).allowCondition();
    }
}

