/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.HudRendered;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2503;
import net.minecraft.class_2520;

public class CooldownPower
extends Power
implements HudRendered {
    protected long lastUseTime;
    public final int cooldownDuration;
    private final HudRender hudRender;

    public CooldownPower(PowerType<?> type, class_1309 entity, int cooldownDuration, HudRender hudRender) {
        super(type, entity);
        this.cooldownDuration = cooldownDuration;
        this.hudRender = hudRender;
    }

    public boolean canUse() {
        return this.entity.method_5770().method_8510() >= this.lastUseTime + (long)this.cooldownDuration && this.isActive();
    }

    public void use() {
        this.lastUseTime = this.entity.method_5770().method_8510();
        PowerHolderComponent.syncPower((class_1297)this.entity, this.type);
    }

    public float getProgress() {
        float time = this.entity.method_5770().method_8510() - this.lastUseTime;
        return Math.min(1.0f, Math.max(time / (float)this.cooldownDuration, 0.0f));
    }

    public int getRemainingTicks() {
        return (int)Math.max(0L, (long)this.cooldownDuration - (this.entity.method_5770().method_8510() - this.lastUseTime));
    }

    public void modify(int changeInTicks) {
        this.lastUseTime += (long)changeInTicks;
        long currentTime = this.entity.method_5770().method_8510();
        if (this.lastUseTime > currentTime) {
            this.lastUseTime = currentTime;
        }
    }

    public void setCooldown(int cooldownInTicks) {
        long currentTime = this.entity.method_5770().method_8510();
        this.lastUseTime = currentTime - (long)Math.min(cooldownInTicks, this.cooldownDuration);
    }

    @Override
    public class_2520 toTag() {
        return class_2503.method_23251((long)this.lastUseTime);
    }

    @Override
    public void fromTag(class_2520 tag) {
        this.lastUseTime = ((class_2503)tag).method_10699();
    }

    @Override
    public HudRender getRenderSettings() {
        return this.hudRender;
    }

    @Override
    public float getFill() {
        return this.getProgress();
    }

    @Override
    public boolean shouldRender() {
        return this.entity.method_5770().method_8510() - this.lastUseTime <= (long)this.cooldownDuration;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("cooldown"), new SerializableData().add("cooldown", SerializableDataTypes.INT).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER), data -> (type, player) -> new CooldownPower((PowerType<?>)type, (class_1309)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"))).allowCondition();
    }
}

