/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1324;

public class ConditionedAttributePower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final int tickRate;
    private final boolean updateHealth;

    public ConditionedAttributePower(PowerType<?> type, class_1309 entity, int tickRate, boolean updateHealth) {
        super(type, entity);
        this.setTicking(true);
        this.tickRate = tickRate;
        this.updateHealth = updateHealth;
    }

    @Override
    public void tick() {
        if (this.entity.field_6012 % this.tickRate == 0) {
            if (this.isActive()) {
                this.addMods();
            } else {
                this.removeMods();
            }
        }
    }

    @Override
    public void onRemoved() {
        this.removeMods();
    }

    public ConditionedAttributePower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public void addMods() {
        float previousMaxHealth = this.entity.method_6063();
        float previousHealthPercent = this.entity.method_6032() / previousMaxHealth;
        this.modifiers.forEach(mod -> {
            class_1324 instance;
            if (this.entity.method_6127().method_27306(mod.getAttribute()) && (instance = this.entity.method_5996(mod.getAttribute())) != null && !instance.method_6196(mod.getModifier())) {
                instance.method_26835(mod.getModifier());
            }
        });
        float afterMaxHealth = this.entity.method_6063();
        if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
            this.entity.method_6033(afterMaxHealth * previousHealthPercent);
        }
    }

    public void removeMods() {
        float previousMaxHealth = this.entity.method_6063();
        float previousHealthPercent = this.entity.method_6032() / previousMaxHealth;
        this.modifiers.forEach(mod -> {
            class_1324 instance;
            if (this.entity.method_6127().method_27306(mod.getAttribute()) && (instance = this.entity.method_5996(mod.getAttribute())) != null && instance.method_6196(mod.getModifier())) {
                instance.method_6202(mod.getModifier());
            }
        });
        float afterMaxHealth = this.entity.method_6063();
        if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
            this.entity.method_6033(afterMaxHealth * previousHealthPercent);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("conditioned_attribute"), new SerializableData().add("modifier", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("tick_rate", SerializableDataTypes.INT, (Object)20).add("update_health", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, player) -> {
            ConditionedAttributePower ap = new ConditionedAttributePower((PowerType<?>)type, (class_1309)player, data.getInt("tick_rate"), data.getBoolean("update_health"));
            if (data.isPresent("modifier")) {
                ap.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                List modifierList = (List)data.get("modifiers");
                modifierList.forEach(ap::addModifier);
            }
            return ap;
        }).allowCondition();
    }
}

