/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;

public class AttributePower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final boolean updateHealth;

    public AttributePower(PowerType<?> type, class_1309 entity, boolean updateHealth) {
        super(type, entity);
        this.updateHealth = updateHealth;
    }

    public AttributePower(PowerType<?> type, class_1309 entity, boolean updateHealth, class_1320 attribute, class_1322 modifier) {
        this(type, entity, updateHealth);
        this.addModifier(attribute, modifier);
    }

    public AttributePower addModifier(class_1320 attribute, class_1322 modifier) {
        AttributedEntityAttributeModifier mod = new AttributedEntityAttributeModifier(attribute, modifier);
        this.modifiers.add(mod);
        return this;
    }

    public AttributePower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    @Override
    public void onAdded() {
        if (!this.entity.method_37908().field_9236) {
            float previousMaxHealth = this.entity.method_6063();
            float previousHealthPercent = this.entity.method_6032() / previousMaxHealth;
            this.modifiers.forEach(mod -> {
                if (this.entity.method_6127().method_27306(mod.getAttribute())) {
                    this.entity.method_5996(mod.getAttribute()).method_26835(mod.getModifier());
                }
            });
            float afterMaxHealth = this.entity.method_6063();
            if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
                this.entity.method_6033(afterMaxHealth * previousHealthPercent);
            }
        }
    }

    @Override
    public void onRemoved() {
        if (!this.entity.method_37908().field_9236) {
            float previousMaxHealth = this.entity.method_6063();
            float previousHealthPercent = this.entity.method_6032() / previousMaxHealth;
            this.modifiers.forEach(mod -> {
                if (this.entity.method_6127().method_27306(mod.getAttribute())) {
                    this.entity.method_5996(mod.getAttribute()).method_6202(mod.getModifier());
                }
            });
            float afterMaxHealth = this.entity.method_6063();
            if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
                this.entity.method_6033(afterMaxHealth * previousHealthPercent);
            }
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("attribute"), new SerializableData().add("modifier", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("update_health", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, player) -> {
            AttributePower ap = new AttributePower((PowerType<?>)type, (class_1309)player, data.getBoolean("update_health"));
            if (data.isPresent("modifier")) {
                ap.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                List modifierList = (List)data.get("modifiers");
                modifierList.forEach(ap::addModifier);
            }
            return ap;
        });
    }
}

