/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.ActiveInteractionPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2694;
import net.minecraft.class_3545;
import net.minecraft.class_4538;
import org.apache.commons.lang3.tuple.Triple;

public class ActionOnBlockUsePower
extends ActiveInteractionPower {
    private final Consumer<class_1297> entityAction;
    private final Predicate<class_2694> blockCondition;
    private final EnumSet<class_2350> directions;
    private final Consumer<Triple<class_1937, class_2338, class_2350>> blockAction;

    public ActionOnBlockUsePower(PowerType<?> type, class_1309 entity, EnumSet<class_1268> hands, class_1269 actionResult, Predicate<class_1799> itemCondition, Consumer<class_3545<class_1937, class_1799>> heldItemAction, class_1799 itemResult, Consumer<class_3545<class_1937, class_1799>> resultItemAction, Consumer<class_1297> entityAction, Predicate<class_2694> blockCondition, EnumSet<class_2350> directions, Consumer<Triple<class_1937, class_2338, class_2350>> blockAction, int priority) {
        super(type, entity, hands, actionResult, itemCondition, heldItemAction, itemResult, resultItemAction, priority);
        this.entityAction = entityAction;
        this.blockCondition = blockCondition;
        this.directions = directions;
        this.blockAction = blockAction;
    }

    public boolean shouldExecute(class_2338 blockPos, class_2350 direction, class_1268 hand, class_1799 heldStack) {
        if (!super.shouldExecute(hand, heldStack)) {
            return false;
        }
        if (!this.directions.contains(direction)) {
            return false;
        }
        return this.blockCondition == null || this.blockCondition.test(new class_2694((class_4538)this.entity.method_37908(), blockPos, true));
    }

    public class_1269 executeAction(class_2338 blockPos, class_2350 direction, class_1268 hand) {
        if (this.blockAction != null) {
            this.blockAction.accept((Triple<class_1937, class_2338, class_2350>)Triple.of((Object)this.entity.method_37908(), (Object)blockPos, (Object)direction));
        }
        if (this.entityAction != null) {
            this.entityAction.accept((class_1297)this.entity);
        }
        this.performActorItemStuff(this, (class_1657)this.entity, hand);
        return this.getActionResult();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("action_on_block_use"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("block_action", ApoliDataTypes.BLOCK_ACTION, null).add("directions", SerializableDataTypes.DIRECTION_SET, EnumSet.allOf(class_2350.class)).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("hands", SerializableDataTypes.HAND_SET, EnumSet.allOf(class_1268.class)).add("result_stack", SerializableDataTypes.ITEM_STACK, null).add("held_item_action", ApoliDataTypes.ITEM_ACTION, null).add("result_item_action", ApoliDataTypes.ITEM_ACTION, null).add("action_result", SerializableDataTypes.ACTION_RESULT, (Object)class_1269.field_5812).add("priority", SerializableDataTypes.INT, (Object)0), data -> (type, player) -> new ActionOnBlockUsePower((PowerType<?>)type, (class_1309)player, (EnumSet)data.get("hands"), (class_1269)data.get("action_result"), (Predicate)data.get("item_condition"), (Consumer)data.get("held_item_action"), (class_1799)data.get("result_stack"), (Consumer)data.get("result_item_action"), (Consumer)data.get("entity_action"), (Predicate)data.get("block_condition"), (EnumSet)data.get("directions"), (Consumer)data.get("block_action"), (Integer)data.get("priority"))).allowCondition();
    }
}

