/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.networking;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.ActionOnLandPower;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PreventBeingUsedPower;
import io.github.apace100.apoli.power.PreventEntityUsePower;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;

public class ModPacketsC2S {
    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.USE_ACTIVE_POWERS, ModPacketsC2S::useActivePowers);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.PLAYER_LANDED, ModPacketsC2S::playerLanded);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.PREVENTED_ENTITY_USE, ModPacketsC2S::interactionPrevented);
    }

    private static void playerLanded(MinecraftServer minecraftServer, class_3222 playerEntity, class_3244 serverPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        minecraftServer.execute(() -> PowerHolderComponent.getPowers((class_1297)playerEntity, ActionOnLandPower.class).forEach(ActionOnLandPower::executeAction));
    }

    private static void interactionPrevented(MinecraftServer minecraftServer, class_3222 playerEntity, class_3244 serverPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int otherEntityId = packetByteBuf.readInt();
        int handOrdinal = packetByteBuf.readInt();
        minecraftServer.execute(() -> {
            class_1297 otherEntity = playerEntity.method_37908().method_8469(otherEntityId);
            class_1268 hand = class_1268.values()[handOrdinal];
            if (otherEntity == null) {
                Apoli.LOGGER.warn("Received unknown entity for prevented interaction");
            } else {
                boolean prevented = false;
                for (PreventEntityUsePower peup : PowerHolderComponent.getPowers((class_1297)playerEntity, PreventEntityUsePower.class)) {
                    if (!peup.doesApply(otherEntity, hand, playerEntity.method_5998(hand))) continue;
                    peup.executeAction(otherEntity, hand);
                    prevented = true;
                    break;
                }
                if (!prevented) {
                    for (PreventBeingUsedPower pbup : PowerHolderComponent.getPowers(otherEntity, PreventBeingUsedPower.class)) {
                        if (!pbup.doesApply((class_1657)playerEntity, hand, playerEntity.method_5998(hand))) continue;
                        pbup.executeAction((class_1657)playerEntity, hand);
                        prevented = true;
                        break;
                    }
                    if (!prevented) {
                        Apoli.LOGGER.warn("Couldn't find corresponding entity use preventing power");
                    }
                }
            }
        });
    }

    private static void useActivePowers(MinecraftServer minecraftServer, class_3222 playerEntity, class_3244 serverPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int count = packetByteBuf.readInt();
        class_2960[] powerIds = new class_2960[count];
        for (int i = 0; i < count; ++i) {
            powerIds[i] = packetByteBuf.method_10810();
        }
        minecraftServer.execute(() -> {
            PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)playerEntity);
            for (class_2960 id : powerIds) {
                PowerType type = PowerTypeRegistry.get(id);
                Object power = component.getPower(type);
                if (!(power instanceof Active)) continue;
                ((Active)power).onUse();
            }
        });
    }

    private static void handleHandshakeReply(MinecraftServer minecraftServer, class_3248 serverLoginNetworkHandler, boolean understood, class_2540 packetByteBuf, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
        if (understood) {
            int clientSemVerLength = packetByteBuf.readInt();
            int[] clientSemVer = new int[clientSemVerLength];
            boolean mismatch = clientSemVerLength != Apoli.SEMVER.length;
            for (int i = 0; i < clientSemVerLength; ++i) {
                clientSemVer[i] = packetByteBuf.readInt();
                if (i >= clientSemVerLength - 1 || clientSemVer[i] == Apoli.SEMVER[i]) continue;
                mismatch = true;
            }
            if (mismatch) {
                StringBuilder clientVersionString = new StringBuilder();
                for (int i = 0; i < clientSemVerLength; ++i) {
                    clientVersionString.append(clientSemVer[i]);
                    if (i >= clientSemVerLength - 1) continue;
                    clientVersionString.append(".");
                }
                serverLoginNetworkHandler.method_14380((class_2561)class_2561.method_43469((String)"apoli.gui.version_mismatch", (Object[])new Object[]{Apoli.VERSION, clientVersionString}));
            }
        } else {
            serverLoginNetworkHandler.method_14380((class_2561)class_2561.method_43470((String)("This server requires you to install the Apoli mod (v" + Apoli.VERSION + ") to play.")));
        }
    }

    private static void handshake(class_3248 serverLoginNetworkHandler, MinecraftServer minecraftServer, PacketSender packetSender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        packetSender.sendPacket(ModPackets.HANDSHAKE, PacketByteBufs.empty());
    }
}

