/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.IdentifiedLootTable;
import io.github.apace100.apoli.access.ReplacingLootContext;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ReplaceLootTablePower;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_4140;
import net.minecraft.class_47;
import net.minecraft.class_4836;
import net.minecraft.class_52;
import net.minecraft.class_60;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_52.class})
public class LootTableMixin
implements IdentifiedLootTable {
    @Unique
    private class_2960 apoli$id;
    @Unique
    private class_60 apoli$lootManager;

    @Override
    public void setId(class_2960 id, class_60 lootManager) {
        this.apoli$id = id;
        this.apoli$lootManager = lootManager;
    }

    @Override
    public class_2960 getId() {
        return this.apoli$id;
    }

    @Inject(method={"generateUnprocessedLoot(Lnet/minecraft/loot/context/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyLootTable(class_47 context, Consumer<class_1799> lootConsumer, CallbackInfo ci) {
        if (((ReplacingLootContext)context).isReplaced((class_52)this)) {
            return;
        }
        if (context.method_300(class_181.field_1226)) {
            class_4836 piglin;
            Optional optional;
            class_176 type = ((ReplacingLootContext)context).getType();
            class_1297 entity = (class_1297)context.method_296(class_181.field_1226);
            if (type == class_173.field_1176) {
                if (entity instanceof class_1536) {
                    class_1536 bobber = (class_1536)entity;
                    entity = bobber.method_6947();
                }
            } else if (type == class_173.field_1173) {
                if (context.method_300(class_181.field_1230)) {
                    entity = (class_1297)context.method_296(class_181.field_1230);
                }
            } else if (type == class_173.field_22403 && entity instanceof class_4836 && (optional = (piglin = (class_4836)entity).method_18868().method_46873(class_4140.field_18444)).isPresent()) {
                entity = (class_1297)optional.get();
            }
            List<ReplaceLootTablePower> powers = PowerHolderComponent.getPowers(entity, ReplaceLootTablePower.class);
            powers = powers.stream().filter(p -> p.hasReplacement(this.apoli$id) && p.doesApply(context)).sorted(Comparator.comparing(ReplaceLootTablePower::getPriority)).toList();
            if (powers.size() == 0) {
                return;
            }
            ReplaceLootTablePower.addToStack((class_52)this);
            class_52 replacement = null;
            for (ReplaceLootTablePower power : powers) {
                class_2960 id = power.getReplacement(this.apoli$id);
                replacement = this.apoli$lootManager.getLootTable(id);
                ReplaceLootTablePower.addToStack(replacement);
            }
            ((ReplacingLootContext)context).setReplaced((class_52)this);
            replacement.method_328(context, lootConsumer);
            ReplaceLootTablePower.clearStack();
            ci.cancel();
        }
    }

    @Inject(method={"generateUnprocessedLoot(Lnet/minecraft/loot/context/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/loot/context/LootContext;markActive(Lnet/minecraft/loot/context/LootContext$Entry;)Z")})
    private void popReplacementStack(class_47 context, Consumer<class_1799> lootConsumer, CallbackInfo ci) {
        ReplaceLootTablePower.pop();
    }

    @Inject(method={"generateUnprocessedLoot(Lnet/minecraft/loot/context/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/loot/context/LootContext;markInactive(Lnet/minecraft/loot/context/LootContext$Entry;)V")})
    private void restoreReplacementStack(class_47 context, Consumer<class_1799> lootConsumer, CallbackInfo ci) {
        ReplaceLootTablePower.restore();
    }
}

