/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.InvisibilityPower;
import io.github.apace100.apoli.power.ModelColorPower;
import io.github.apace100.apoli.power.PreventFeatureRenderPower;
import io.github.apace100.apoli.power.ShakingPower;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_922.class})
public abstract class LivingEntityRendererMixin
extends class_897<class_1309> {
    protected LivingEntityRendererMixin(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Inject(method={"isShaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void letPlayersShakeTheirBodies(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((class_1297)entity, ShakingPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE"), ordinal=2)
    private boolean preventOutlineRendering(boolean original, class_1309 livingEntity) {
        List<InvisibilityPower> invisibilityPowers = PowerHolderComponent.getPowers((class_1297)livingEntity, InvisibilityPower.class);
        if (invisibilityPowers.size() > 0 && invisibilityPowers.stream().noneMatch(InvisibilityPower::shouldRenderOutline)) {
            return false;
        }
        return original;
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;", shift=At.Shift.BEFORE))
    private class_1921 changeRenderLayerWhenTranslucent(class_1921 original, class_1309 entity) {
        if (entity != null && PowerHolderComponent.getPowers((class_1297)entity, ModelColorPower.class).stream().anyMatch(ModelColorPower::isTranslucent)) {
            return class_1921.method_29379((class_2960)this.method_3931((class_1297)entity));
        }
        return original;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/feature/FeatureRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/Entity;FFFFFF)V"))
    private void preventFeatureRendering(class_3887 featureRenderer, class_4587 matrices, class_4597 vertexConsumers, int light, class_1297 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, class_1309 livingEntity) {
        List<InvisibilityPower> invisibilityPowers = PowerHolderComponent.getPowers((class_1297)livingEntity, InvisibilityPower.class);
        if (invisibilityPowers.size() > 0 && invisibilityPowers.stream().noneMatch(InvisibilityPower::shouldRenderArmor)) {
            return;
        }
        Class<?> cls = featureRenderer.getClass();
        if (!PowerHolderComponent.getPowers(entity, PreventFeatureRenderPower.class).stream().anyMatch(p -> p.doesApply(cls))) {
            featureRenderer.method_4199(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
        }
    }

    @ModifyArgs(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V"))
    @Environment(value=EnvType.CLIENT)
    private void renderColorChangedModel(Args args, class_1309 livingEntity, float f, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        List<ModelColorPower> modelColorPowers = PowerHolderComponent.getPowers((class_1297)livingEntity, ModelColorPower.class);
        if (modelColorPowers.size() > 0) {
            float r = modelColorPowers.stream().map(ModelColorPower::getRed).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float g = modelColorPowers.stream().map(ModelColorPower::getGreen).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float b2 = modelColorPowers.stream().map(ModelColorPower::getBlue).reduce((a, c) -> Float.valueOf(a.floatValue() * c.floatValue())).get().floatValue();
            float a2 = modelColorPowers.stream().map(ModelColorPower::getAlpha).min(Float::compare).get().floatValue();
            args.set(4, (Object)Float.valueOf(((Float)args.get(4)).floatValue() * r));
            args.set(5, (Object)Float.valueOf(((Float)args.get(5)).floatValue() * g));
            args.set(6, (Object)Float.valueOf(((Float)args.get(6)).floatValue() * b2));
            args.set(7, (Object)Float.valueOf(((Float)args.get(7)).floatValue() * a2));
        }
    }
}

