/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PreventItemUsePower;
import io.github.apace100.apoli.power.TooltipPower;
import io.github.apace100.apoli.util.ApoliConfigClient;
import io.github.apace100.apoli.util.StackPowerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1799.class})
public abstract class ItemStackMixinClient {
    @Shadow
    public abstract class_1839 method_7976();

    @Shadow
    protected abstract int method_30266();

    @Shadow
    private static boolean method_30267(int flags, class_1799.class_5422 tooltipSection) {
        return (flags & tooltipSection.method_30269()) == 0;
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addUnusableTooltip(@Nullable class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        if (player != null) {
            ApoliConfigClient.Tooltips config = ((ApoliConfigClient)Apoli.config).tooltips;
            if (!config.showUsabilityHints || !ItemStackMixinClient.method_30267(this.method_30266(), class_1799.class_5422.field_25773)) {
                return;
            }
            List<PreventItemUsePower> powers = PowerHolderComponent.getPowers((class_1297)player, PreventItemUsePower.class).stream().filter(p -> p.doesPrevent((class_1799)this)).toList();
            int powerCountWithHidden = powers.size();
            powers = powers.stream().filter(p -> !p.getType().isHidden()).toList();
            if (powerCountWithHidden == 0) {
                return;
            }
            String translationKeyBase = "tooltip.apoli.unusable." + this.method_7976().name().toLowerCase(Locale.ROOT);
            class_124 textColor = class_124.field_1080;
            class_124 powerColor = class_124.field_1061;
            if (config.compactUsabilityHints || powers.size() == 0) {
                if (powers.size() == 1) {
                    PreventItemUsePower power = powers.get(0);
                    class_5250 preventText = class_2561.method_43469((String)(translationKeyBase + ".single"), (Object[])new Object[]{power.getType().getName().method_27692(powerColor)}).method_27692(textColor);
                    list.add((class_2561)preventText);
                } else {
                    list.add((class_2561)class_2561.method_43469((String)(translationKeyBase + ".multiple"), (Object[])new Object[]{class_2561.method_43470((String)("" + (powers.size() == 0 ? powerCountWithHidden : powers.size()))).method_27692(powerColor)}).method_27692(textColor));
                }
            } else {
                class_5250 powerNameList = powers.get(0).getType().getName().method_27692(powerColor);
                for (int i = 1; i < powers.size(); ++i) {
                    powerNameList = powerNameList.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(textColor));
                    powerNameList = powerNameList.method_10852((class_2561)powers.get(i).getType().getName().method_27692(powerColor));
                }
                class_5250 preventText = class_2561.method_43469((String)(translationKeyBase + ".single"), (Object[])new Object[]{powerNameList}).method_27692(textColor);
                list.add((class_2561)preventText);
            }
        }
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasNbt()Z", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addEquipmentPowerTooltips(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        for (class_1304 slot : class_1304.values()) {
            List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers((class_1799)this, slot).stream().filter(sp -> !sp.isHidden).toList();
            if (powers.size() <= 0) continue;
            list.add((class_2561)class_2561.method_43473());
            list.add((class_2561)class_2561.method_43471((String)("item.modifiers." + slot.method_5923())).method_27692(class_124.field_1080));
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    PowerType powerType = PowerTypeRegistry.get(sp.powerId);
                    list.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)powerType.getName()).method_27692(sp.isNegative ? class_124.field_1061 : class_124.field_1078));
                    if (context.method_8035()) {
                        list.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)powerType.getDescription()).method_27692(class_124.field_1080));
                    }
                }
            });
        }
        PowerHolderComponent.getPowers((class_1297)player, TooltipPower.class).stream().filter(t -> t.doesApply((class_1799)this)).sorted(Comparator.comparing(TooltipPower::getOrder)).forEachOrdered(t -> t.addToTooltip(list));
    }
}

