/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.access.SubmergableEntity;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnLandPower;
import io.github.apace100.apoli.power.FireImmunityPower;
import io.github.apace100.apoli.power.GroundedPower;
import io.github.apace100.apoli.power.IgnoreWaterPower;
import io.github.apace100.apoli.power.InvisibilityPower;
import io.github.apace100.apoli.power.InvulnerablePower;
import io.github.apace100.apoli.power.ModifyVelocityPower;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.SwimmingPower;
import io.github.apace100.calio.Calio;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements MovingEntity,
SubmergableEntity {
    @Shadow
    public class_1937 field_6002;
    @Shadow
    public float field_5994;
    @Shadow
    protected boolean field_5952;
    @Shadow
    @Nullable
    protected Set<class_6862<class_3611>> field_25599;
    @Shadow
    protected Object2DoubleMap<class_6862<class_3611>> field_5964;
    private boolean isMoving;
    private float distanceBefore;

    @Inject(method={"isFireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeFullyFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((class_1297)this, FireImmunityPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract double method_5861(class_6862<class_3611> var1);

    @Shadow
    public abstract class_243 method_18798();

    @Inject(method={"isTouchingWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeEntitiesIgnoreWater(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((class_1297)this, IgnoreWaterPower.class) && this instanceof WaterMovingEntity && ((WaterMovingEntity)((Object)this)).isInMovementPhase()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"fall"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onLandedUpon(Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V")})
    private void invokeActionOnLand(CallbackInfo ci) {
        List<ActionOnLandPower> powers = PowerHolderComponent.getPowers((class_1297)this, ActionOnLandPower.class);
        powers.forEach(ActionOnLandPower::executeAction);
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void makeOriginInvulnerable(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        PowerHolderComponent component;
        if (this instanceof class_1309 && (component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this)).getPowers(InvulnerablePower.class).stream().anyMatch(inv -> inv.doesApply(damageSource))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(class_1297 entity) {
        if (PowerHolderComponent.hasPower(entity, SwimmingPower.class) && entity.method_5681() && !(this.method_5861((class_6862<class_3611>)class_3486.field_15517) > 0.0)) {
            return false;
        }
        return entity.method_5637();
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvisible"}, cancellable=true)
    private void phantomInvisibility(CallbackInfoReturnable<Boolean> info) {
        if (PowerHolderComponent.hasPower((class_1297)this, InvisibilityPower.class)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;ofFloored(DDD)Lnet/minecraft/util/math/BlockPos;")}, method={"pushOutOfBlocks"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo info) {
        List<PhasingPower> powers = PowerHolderComponent.getPowers((class_1297)this, PhasingPower.class);
        if (powers.size() > 0 && powers.stream().anyMatch(phasingPower -> phasingPower.doesApply(class_2338.method_49637((double)x, (double)y, (double)z)))) {
            info.cancel();
        }
    }

    @Redirect(method={"method_30022"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;getCollisionShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/shape/VoxelShape;"))
    private class_265 preventPhasingSuffocation(class_2680 state, class_1922 world, class_2338 pos) {
        return state.method_26194(world, pos, class_3726.method_16195((class_1297)((class_1297)this)));
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void saveDistanceTraveled(class_1313 type, class_243 movement, CallbackInfo ci) {
        this.isMoving = false;
        this.distanceBefore = this.field_5994;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V")})
    private void checkIsMoving(class_1313 type, class_243 movement, CallbackInfo ci) {
        if (this.field_5994 > this.distanceBefore) {
            this.isMoving = true;
        }
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), argsOnly=true)
    private class_243 modifyMovementVelocity(class_243 original, class_1313 movementType) {
        if (movementType != class_1313.field_6308) {
            return original;
        }
        class_243 modified = new class_243(PowerHolderComponent.modify((class_1297)this, ModifyVelocityPower.class, original.field_1352, p -> p.axes.contains(class_2350.class_2351.field_11048), null), PowerHolderComponent.modify((class_1297)this, ModifyVelocityPower.class, original.field_1351, p -> p.axes.contains(class_2350.class_2351.field_11052), null), PowerHolderComponent.modify((class_1297)this, ModifyVelocityPower.class, original.field_1350, p -> p.axes.contains(class_2350.class_2351.field_11051), null));
        return modified;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getLandingPos()Lnet/minecraft/util/math/BlockPos;")})
    private void forceGrounded(class_1313 movementType, class_243 movement, CallbackInfo ci) {
        if (PowerHolderComponent.hasPower((class_1297)this, GroundedPower.class)) {
            this.field_5952 = true;
        }
    }

    @Override
    public boolean isSubmergedInLoosely(class_6862<class_3611> tag) {
        if (tag == null || this.field_25599 == null) {
            return false;
        }
        return this.field_25599.contains(tag);
    }

    @Override
    public double getFluidHeightLoosely(class_6862<class_3611> tag) {
        if (tag == null) {
            return 0.0;
        }
        if (this.field_5964.containsKey(tag)) {
            return this.field_5964.getDouble(tag);
        }
        for (class_6862 ft : this.field_5964.keySet()) {
            if (!Calio.areTagsEqual((class_5321)class_7924.field_41270, (class_6862)ft, tag)) continue;
            return this.field_5964.getDouble((Object)ft);
        }
        return 0.0;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }
}

