/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.authlib.GameProfile;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.IgnoreWaterPower;
import io.github.apace100.apoli.power.ModifyAirSpeedPower;
import io.github.apace100.apoli.power.PreventSprintingPower;
import io.github.apace100.apoli.power.SwimmingPower;
import net.minecraft.class_1297;
import net.minecraft.class_1656;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
extends class_742
implements WaterMovingEntity {
    private boolean isMoving = false;
    @Shadow
    @Final
    public class_634 field_3944;

    public ClientPlayerEntityMixin(class_638 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(at={@At(value="HEAD")}, method={"isSubmergedInWater"}, cancellable=true)
    private void allowSwimming(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((class_1297)this, SwimmingPower.class)) {
            cir.setReturnValue((Object)true);
        } else if (PowerHolderComponent.hasPower((class_1297)this, IgnoreWaterPower.class)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickMovement"})
    private void beginMovementPhase(CallbackInfo ci) {
        this.isMoving = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"tickMovement"})
    private void endMovementPhase(CallbackInfo ci) {
        this.isMoving = false;
    }

    @Override
    public boolean isInMovementPhase() {
        return this.isMoving;
    }

    @Redirect(method={"tickMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerAbilities;getFlySpeed()F"))
    private float modifyFlySpeed(class_1656 playerAbilities) {
        return PowerHolderComponent.modify((class_1297)this, ModifyAirSpeedPower.class, playerAbilities.method_7252());
    }

    @ModifyVariable(method={"tickMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;isOnGround()Z", ordinal=0), ordinal=4)
    private boolean modifySprintAbility(boolean original) {
        boolean prevent = PowerHolderComponent.hasPower((class_1297)this, PreventSprintingPower.class);
        return !prevent && original;
    }
}

