/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.global;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.global.GlobalPowerSet;
import io.github.apace100.apoli.global.GlobalPowerSetLoader;
import io.github.apace100.apoli.power.PowerType;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;

public class GlobalPowerSetUtil {
    public static class_2960 POWER_SOURCE = Apoli.identifier("global");

    public static List<GlobalPowerSet> getApplicableSets(class_1299<?> type) {
        LinkedList<GlobalPowerSet> result = new LinkedList<GlobalPowerSet>();
        for (GlobalPowerSet gps : GlobalPowerSetLoader.ALL) {
            if (!gps.doesApply(type)) continue;
            result.add(gps);
        }
        result.sort(GlobalPowerSet::compareTo);
        return result;
    }

    public static Set<class_2960> getPowerTypeIds(List<GlobalPowerSet> powerSets) {
        return powerSets.stream().flatMap(gps -> gps.getPowerTypes().stream()).map(PowerType::getIdentifier).collect(Collectors.toSet());
    }

    public static void applyGlobalPowers(class_1297 entity) {
        if (entity.method_37908().field_9236) {
            return;
        }
        Optional optional = PowerHolderComponent.KEY.maybeGet((Object)entity);
        if (optional.isEmpty()) {
            return;
        }
        PowerHolderComponent phc = (PowerHolderComponent)optional.get();
        List<GlobalPowerSet> sets = GlobalPowerSetUtil.getApplicableSets(entity.method_5864());
        Set<class_2960> ids = GlobalPowerSetUtil.getPowerTypeIds(sets);
        boolean change = GlobalPowerSetUtil.removeExcessPowers(phc, ids);
        for (GlobalPowerSet powerSet : sets) {
            change |= GlobalPowerSetUtil.addMissingPowers(phc, powerSet);
        }
        if (change) {
            phc.sync();
        }
    }

    private static boolean removeExcessPowers(PowerHolderComponent phc, Set<class_2960> expected) {
        List<PowerType<?>> powers = phc.getPowersFromSource(POWER_SOURCE);
        LinkedList toRemove = new LinkedList();
        for (PowerType<Object> pt : powers) {
            class_2960 id = pt.getIdentifier();
            if (expected.contains(id)) continue;
            toRemove.add(pt);
        }
        for (PowerType<Object> pt : toRemove) {
            phc.removePower(pt, POWER_SOURCE);
        }
        return toRemove.size() > 0;
    }

    private static boolean addMissingPowers(PowerHolderComponent phc, GlobalPowerSet powerSet) {
        boolean added = false;
        for (PowerType<?> pt : powerSet.getPowerTypes()) {
            if (phc.hasPower(pt, POWER_SOURCE)) continue;
            phc.addPower(pt, POWER_SOURCE);
            added = true;
        }
        return added;
    }
}

