/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.global;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.global.GlobalPowerSet;
import io.github.apace100.apoli.global.GlobalPowerSetUtil;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class GlobalPowerSetLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final Set<class_2960> DEPENDENCIES = Set.of(Apoli.identifier("powers"));
    public static List<GlobalPowerSet> ALL = new LinkedList<GlobalPowerSet>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public GlobalPowerSetLoader() {
        super(GSON, "global_powers");
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> GlobalPowerSetUtil.applyGlobalPowers(entity));
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ALL.clear();
        prepared.forEach((id, json) -> {
            if (json.isJsonObject()) {
                SerializableData.Instance data = GlobalPowerSet.DATA.read(json.getAsJsonObject());
                GlobalPowerSet gps = (GlobalPowerSet)GlobalPowerSet.FACTORY.fromData(data);
                List<PowerType<?>> invalidPowerTypes = gps.validate();
                if (invalidPowerTypes.size() > 0) {
                    Apoli.LOGGER.error("Global power set \"{}\" contained invalid powers: {}", id, (Object)invalidPowerTypes.stream().map(PowerType::getIdentifier).map(class_2960::toString).collect(Collectors.joining(", ")));
                }
                ALL.add(gps);
            }
        });
        Apoli.LOGGER.info("Loaded " + ALL.size() + " global power sets.");
    }

    public class_2960 getFabricId() {
        return Apoli.identifier("global_powers");
    }

    public Collection<class_2960> getFabricDependencies() {
        return DEPENDENCIES;
    }
}

