/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.global;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.calio.registry.DataObject;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.github.apace100.calio.util.TagLike;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.NotNull;

public class GlobalPowerSet
implements Comparable<GlobalPowerSet>,
DataObject<GlobalPowerSet> {
    private final int order;
    private final TagLike<class_1299<?>> entityTypes;
    private final List<PowerType<?>> powerTypes;
    public static final SerializableData DATA = new SerializableData().add("entity_types", SerializableDataTypes.ENTITY_TYPE_TAG_LIKE, null).add("powers", SerializableDataType.list(ApoliDataTypes.POWER_TYPE)).add("order", SerializableDataTypes.INT, (Object)0);
    public static final DataObjectFactory<GlobalPowerSet> FACTORY = new Factory();

    public List<PowerType<?>> getPowerTypes() {
        return this.powerTypes;
    }

    public GlobalPowerSet(int order, TagLike<class_1299<?>> entityTypes, List<PowerType<?>> powerTypes) {
        this.order = order;
        this.entityTypes = entityTypes;
        this.powerTypes = powerTypes;
    }

    public boolean doesApply(class_1299<?> entityType) {
        return this.entityTypes == null || this.entityTypes.contains(entityType);
    }

    public boolean doesApply(class_1297 entity) {
        return this.doesApply(entity.method_5864());
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public int compareTo(@NotNull GlobalPowerSet o) {
        return Integer.compare(this.order, o.order);
    }

    public List<PowerType<?>> validate() {
        List<PowerType<?>> invalid = this.powerTypes.stream().filter(pt -> !PowerTypeRegistry.contains(pt.getIdentifier())).collect(Collectors.toList());
        this.powerTypes.removeAll(invalid);
        invalid.removeIf(pt -> PowerTypeRegistry.isDisabled(pt.getIdentifier()));
        return invalid;
    }

    public DataObjectFactory<GlobalPowerSet> getFactory() {
        return FACTORY;
    }

    private static class Factory
    implements DataObjectFactory<GlobalPowerSet> {
        private Factory() {
        }

        public SerializableData getData() {
            return DATA;
        }

        public GlobalPowerSet fromData(SerializableData.Instance instance) {
            return new GlobalPowerSet(instance.getInt("order"), (TagLike)instance.get("entity_types"), (List)instance.get("powers"));
        }

        public SerializableData.Instance toData(GlobalPowerSet globalPowerSet) {
            SerializableData.Instance inst = new SerializableData.Instance(DATA);
            inst.set("order", (Object)globalPowerSet.order);
            inst.set("entity_types", globalPowerSet.entityTypes);
            inst.set("powers", globalPowerSet.powerTypes);
            return inst;
        }
    }
}

