/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.data;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.NameMutableDamageSource;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8109;
import net.minecraft.class_8110;

public class DamageSourceDescription {
    public static final SerializableData DATA = new SerializableData().add("name", SerializableDataTypes.STRING);
    private static final Multimap<String, class_6862<class_8110>> STRING_TO_TAGS = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
    private static final Map<class_6862<class_8110>, String> TAG_TO_STRING = new HashMap<class_6862<class_8110>, String>();
    private static final int TAG_COUNT;
    private final String name;
    private final Set<class_6862<class_8110>> desiredDamageTypeTags = new HashSet<class_6862<class_8110>>();
    private class_5321<class_8110> damageType;

    private static void registerDamageTypeTagMapping(String jsonKey, class_6862<class_8110> tag) {
        STRING_TO_TAGS.put((Object)jsonKey, tag);
        TAG_TO_STRING.put(tag, jsonKey);
    }

    public DamageSourceDescription(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<class_6862<class_8110>> getDamageTypeTags() {
        return Set.copyOf(this.desiredDamageTypeTags);
    }

    public void addDamageTypeTag(class_6862<class_8110> damageTypeTag) {
        this.desiredDamageTypeTags.add(damageTypeTag);
    }

    public class_5321<class_8110> getDamageType(class_8109 damageSources) {
        if (this.damageType == null) {
            this.findBestMatchingDamageType(damageSources);
        }
        return this.damageType;
    }

    public class_1282 create(class_8109 damageSources) {
        class_1282 damageSource = damageSources.method_48795(this.getDamageType(damageSources));
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    public class_1282 create(class_8109 damageSources, class_1297 attacker) {
        class_1282 damageSource = damageSources.method_48796(this.getDamageType(damageSources), attacker);
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    public class_1282 create(class_8109 damageSources, class_1297 source, class_1297 attacker) {
        class_1282 damageSource = damageSources.method_48797(this.getDamageType(damageSources), source, attacker);
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    private void overwriteDamageSourceMessageKey(class_1282 source) {
        ((NameMutableDamageSource)source).setName(this.name);
    }

    private void findBestMatchingDamageType(class_8109 damageSources) {
        class_6880 bestMatch;
        Optional<class_6880.class_6883> bestMatchingDamageType = damageSources.field_42296.method_40270().max(Comparator.comparingInt(this::getTagMatches));
        if (bestMatchingDamageType.isPresent()) {
            bestMatch = (class_6880)bestMatchingDamageType.get();
            int bestMatchTagCount = this.getTagMatches((class_6880<class_8110>)bestMatch);
            if (bestMatchTagCount < TAG_COUNT) {
                Apoli.LOGGER.warn("Could not find a perfect damage type for legacy damage source field, best match: {} out of {} tags with damage type \"{}\". Consider creating your own custom damage type.", (Object)bestMatchTagCount, (Object)TAG_COUNT, (Object)bestMatch.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("<unknown>"));
            }
        } else {
            throw new NoSuchElementException("Damage type registry was empty or not loaded yet");
        }
        this.damageType = (class_5321)bestMatch.method_40230().orElseThrow();
    }

    private int getTagMatches(class_6880<class_8110> damageType) {
        int count = 0;
        for (class_6862 tag : STRING_TO_TAGS.values()) {
            if (damageType.method_40220(tag) != this.desiredDamageTypeTags.contains(tag)) continue;
            ++count;
        }
        return count;
    }

    public static DamageSourceDescription fromData(SerializableData.Instance dataInstance) {
        DamageSourceDescription damageSourceDescription = new DamageSourceDescription(dataInstance.getString("name"));
        for (String jsonKey : STRING_TO_TAGS.keySet()) {
            if (!dataInstance.getBoolean(jsonKey)) continue;
            STRING_TO_TAGS.get((Object)jsonKey).forEach(damageSourceDescription::addDamageTypeTag);
        }
        return damageSourceDescription;
    }

    public static SerializableData.Instance toData(SerializableData data, DamageSourceDescription damageSourceDescription) {
        SerializableData.Instance instance = new SerializableData.Instance(data);
        instance.set("name", (Object)damageSourceDescription.getName());
        Set<class_6862<class_8110>> tags = damageSourceDescription.getDamageTypeTags();
        for (Map.Entry<class_6862<class_8110>, String> damageTagPair : TAG_TO_STRING.entrySet()) {
            class_6862<class_8110> tag = damageTagPair.getKey();
            String jsonKey = damageTagPair.getValue();
            boolean isTrueAlready = instance.isPresent(jsonKey) && instance.getBoolean(jsonKey);
            instance.set(jsonKey, (Object)(isTrueAlready || tags.contains(tag) ? 1 : 0));
        }
        return instance;
    }

    static {
        DamageSourceDescription.registerDamageTypeTagMapping("bypasses_armor", (class_6862<class_8110>)class_8103.field_42241);
        DamageSourceDescription.registerDamageTypeTagMapping("fire", (class_6862<class_8110>)class_8103.field_42246);
        DamageSourceDescription.registerDamageTypeTagMapping("unblockable", (class_6862<class_8110>)class_8103.field_43116);
        DamageSourceDescription.registerDamageTypeTagMapping("magic", (class_6862<class_8110>)class_8103.field_42248);
        DamageSourceDescription.registerDamageTypeTagMapping("magic", (class_6862<class_8110>)class_8103.field_42260);
        DamageSourceDescription.registerDamageTypeTagMapping("out_of_world", (class_6862<class_8110>)class_8103.field_42242);
        DamageSourceDescription.registerDamageTypeTagMapping("projectile", (class_6862<class_8110>)class_8103.field_42247);
        DamageSourceDescription.registerDamageTypeTagMapping("explosive", (class_6862<class_8110>)class_8103.field_42249);
        for (String jsonKey : STRING_TO_TAGS.keySet()) {
            DATA.add(jsonKey, SerializableDataTypes.BOOLEAN, (Object)false);
        }
        TAG_COUNT = STRING_TO_TAGS.values().size();
    }
}

