/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.apoli.command.PowerOperation;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2214;
import net.minecraft.class_2233;
import net.minecraft.class_2561;
import net.minecraft.class_267;

public class ResourceCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resource").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"has").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, SubCommand.HAS)))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, SubCommand.GET)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, SubCommand.SET))))))).then(class_2170.method_9247((String)"change").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, SubCommand.CHANGE))))))).then(class_2170.method_9247((String)"operation").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(class_2170.method_9244((String)"operation", (ArgumentType)PowerOperation.operation()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2233.method_9447()).then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, SubCommand.OPERATION)))))))));
    }

    private static int resource(CommandContext<class_2168> command, SubCommand sub) throws CommandSyntaxException {
        class_1297 player = class_2186.method_9313(command, (String)"target");
        if (!(player instanceof class_1309)) {
            // empty if block
        }
        PowerType<?> powerType = PowerTypeArgumentType.getPower(command, "power");
        Optional phc = PowerHolderComponent.KEY.maybeGet((Object)player);
        if (phc.isEmpty()) {
            ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.apoli.resource.invalid_entity"));
            return 0;
        }
        Object power = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player)).getPower(powerType);
        if (power instanceof VariableIntPower) {
            VariableIntPower vIntPower = (VariableIntPower)power;
            switch (sub.ordinal()) {
                case 0: {
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.execute.conditional.pass"), true);
                    return 1;
                }
                case 1: {
                    int i = vIntPower.getValue();
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.get.success", (Object[])new Object[]{player.method_5820(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case 2: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    vIntPower.setValue(i);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.set.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.method_5820(), i}), true);
                    return 1;
                }
                case 3: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    int total = vIntPower.getValue() + i;
                    vIntPower.setValue(total);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.add.success.single", (Object[])new Object[]{i, powerType.getIdentifier(), player.method_5820(), total}), true);
                    return 1;
                }
                case 4: {
                    class_267 score = ((class_2168)command.getSource()).method_9211().method_3845().method_1180(class_2233.method_9452(command, (String)"entity"), class_2214.method_9395(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(vIntPower, score);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.operation.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.method_5820(), vIntPower.getValue()}), true);
                    return 1;
                }
            }
        } else if (power instanceof CooldownPower) {
            CooldownPower cooldownPower = (CooldownPower)power;
            switch (sub.ordinal()) {
                case 0: {
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.execute.conditional.pass"), true);
                    return 1;
                }
                case 1: {
                    int i = cooldownPower.getRemainingTicks();
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.get.success", (Object[])new Object[]{player.method_5820(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case 2: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.setCooldown(i);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.set.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.method_5820(), i}), true);
                    return 1;
                }
                case 3: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.modify(i);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.add.success.single", (Object[])new Object[]{i, powerType.getIdentifier(), player.method_5820(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
                case 4: {
                    class_267 score = ((class_2168)command.getSource()).method_9211().method_3845().method_1180(class_2233.method_9452(command, (String)"entity"), class_2214.method_9395(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(cooldownPower, score);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.scoreboard.players.operation.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.method_5820(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
            }
        } else {
            switch (sub.ordinal()) {
                case 0: {
                    ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.execute.conditional.fail"));
                    return 0;
                }
                case 1: {
                    ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.scoreboard.players.get.null", (Object[])new Object[]{powerType.getIdentifier(), player.method_5820()}));
                    return 0;
                }
                case 2: 
                case 3: 
                case 4: {
                    ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43471((String)"argument.scoreHolder.empty"));
                    return 0;
                }
            }
        }
        return 0;
    }

    public static enum SubCommand {
        HAS,
        GET,
        SET,
        CHANGE,
        OPERATION;

    }
}

