/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class PowerCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"power").requires(scs -> scs.method_9259(2))).then(class_2170.method_9247((String)"grant").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(context -> PowerCommand.grantPower((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"source", (ArgumentType)class_2232.method_9441()).executes(context -> PowerCommand.grantPower((CommandContext<class_2168>)context, true))))))).then(class_2170.method_9247((String)"revoke").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(context -> PowerCommand.revokePower((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"source", (ArgumentType)class_2232.method_9441()).executes(context -> PowerCommand.revokePower((CommandContext<class_2168>)context, true))))))).then(class_2170.method_9247((String)"revokeall").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"source", (ArgumentType)class_2232.method_9441()).executes(PowerCommand::revokeAllPowers))))).then(class_2170.method_9247((String)"list").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> PowerCommand.listPowers((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"subpowers", (ArgumentType)BoolArgumentType.bool()).executes(context -> PowerCommand.listPowers((CommandContext<class_2168>)context, true)))))).then(class_2170.method_9247((String)"has").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::hasPower))))).then(class_2170.method_9247((String)"sources").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::getSourcesFromPower))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::removePower))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(PowerCommand::clearAllPowers))));
    }

    private static int grantPower(CommandContext<class_2168> context, boolean isSourceSpecified) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection targets = class_2186.method_9317(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        class_2960 powerSource = isSourceSpecified ? class_2232.method_9443(context, (String)"source") : Apoli.identifier("command");
        LinkedList<class_1297> nonLivingTargets = new LinkedList<class_1297>();
        LinkedList<class_1309> livingTargets = new LinkedList<class_1309>();
        LinkedList<class_1309> processedLivingTargets = new LinkedList<class_1309>();
        for (class_1297 target : targets) {
            if (!(target instanceof class_1309)) {
                nonLivingTargets.add(target);
                continue;
            }
            class_1309 livingTarget = (class_1309)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            if (!powerHolderComponent.addPower(powerType, powerSource)) continue;
            powerHolderComponent.sync();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (isSourceSpecified) {
                if (processedLivingTargets.size() == 1) {
                    source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.grant.success.single", (Object[])new Object[]{((class_1309)processedLivingTargets.getFirst()).method_5476(), powerType.getName()}), true);
                } else {
                    source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.grant.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName()}), true);
                }
            } else if (processedLivingTargets.size() == 1) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.grant_from_source.success.single", (Object[])new Object[]{((class_1309)processedLivingTargets.getFirst()).method_5476(), powerType.getName(), powerSource}), true);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.grant_from_source.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName(), powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.grant.fail.single", (Object[])new Object[]{((class_1309)livingTargets.getFirst()).method_5476(), powerType.getName(), powerSource}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.grant.fail.multiple", (Object[])new Object[]{livingTargets.size(), powerType.getName(), powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.grant.invalid_entity", (Object[])new Object[]{((class_1297)nonLivingTargets.getFirst()).method_5476()}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.grant.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int revokePower(CommandContext<class_2168> context, boolean isSourceSpecified) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection targets = class_2186.method_9317(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        class_2960 powerSource = isSourceSpecified ? class_2232.method_9443(context, (String)"source") : Apoli.identifier("command");
        LinkedList<class_1297> nonLivingTargets = new LinkedList<class_1297>();
        LinkedList<class_1309> livingTargets = new LinkedList<class_1309>();
        LinkedList<class_1309> processedLivingTargets = new LinkedList<class_1309>();
        for (class_1297 target : targets) {
            if (!(target instanceof class_1309)) {
                nonLivingTargets.add(target);
                continue;
            }
            class_1309 livingTarget = (class_1309)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            if (!powerHolderComponent.hasPower(powerType, powerSource)) continue;
            powerHolderComponent.removePower(powerType, powerSource);
            powerHolderComponent.sync();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (!isSourceSpecified) {
                if (processedLivingTargets.size() == 1) {
                    source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.revoke.success.single", (Object[])new Object[]{((class_1309)processedLivingTargets.getFirst()).method_5476(), powerType.getName()}), true);
                } else {
                    source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.revoke.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName()}), true);
                }
            } else if (processedLivingTargets.size() == 1) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.revoke_from_source.success.single", (Object[])new Object[]{((class_1309)processedLivingTargets.getFirst()).method_5476(), powerType.getName(), powerSource}), true);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.revoke_from_source.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName(), powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke.fail.single", (Object[])new Object[]{((class_1309)livingTargets.getFirst()).method_5476(), powerType.getName(), powerSource}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke.fail.multiple", (Object[])new Object[]{powerType.getName(), powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke.invalid_entity", (Object[])new Object[]{((class_1297)nonLivingTargets.getFirst()).method_5476(), powerSource}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke.invalid_entities", (Object[])new Object[]{nonLivingTargets.size(), powerSource}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int revokeAllPowers(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection targets = class_2186.method_9317(context, (String)"targets");
        class_2960 powerSource = class_2232.method_9443(context, (String)"source");
        int revokedPowers = 0;
        LinkedList<class_1297> nonLivingTargets = new LinkedList<class_1297>();
        LinkedList<class_1309> livingTargets = new LinkedList<class_1309>();
        LinkedList<class_1309> processedLivingTargets = new LinkedList<class_1309>();
        for (class_1297 target : targets) {
            if (!(target instanceof class_1309)) {
                nonLivingTargets.add(target);
                continue;
            }
            class_1309 livingTarget = (class_1309)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)target);
            int i = powerHolderComponent.removeAllPowersFromSource(powerSource);
            if (i <= 0) continue;
            powerHolderComponent.sync();
            revokedPowers += i;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            int currentRevokedPowers = revokedPowers;
            if (processedLivingTargets.size() == 1) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.revoke_all.success.single", (Object[])new Object[]{((class_1309)processedLivingTargets.getFirst()).method_5476(), currentRevokedPowers, powerSource}), true);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.revoke_all.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), currentRevokedPowers, powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke_all.fail.single", (Object[])new Object[]{((class_1309)livingTargets.getFirst()).method_5476(), powerSource}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke_all.fail.multiple", (Object[])new Object[]{powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke_all.invalid_entity", (Object[])new Object[]{((class_1297)nonLivingTargets.getFirst()).method_5476(), powerSource}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.revoke_all.invalid_entities", (Object[])new Object[]{nonLivingTargets.size(), powerSource}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int listPowers(CommandContext<class_2168> context, boolean includeSubpowers) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 target = class_2186.method_9313(context, (String)"target");
        LinkedList<class_5250> powers = new LinkedList<class_5250>();
        int powerCount = 0;
        if (!(target instanceof class_1309)) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.list.fail", (Object[])new Object[]{target.method_5476()}));
            return powerCount;
        }
        class_1309 livingTarget = (class_1309)target;
        PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
        for (PowerType<?> powerType : powerHolderComponent.getPowerTypes(includeSubpowers)) {
            LinkedList powerSources = new LinkedList();
            powerHolderComponent.getSources(powerType).forEach(powerSource -> powerSources.add(class_2561.method_30163((String)powerSource.toString())));
            class_2568 powerSourcesOnHover = new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)(powerSources.size() == 1 ? "commands.apoli.list.source" : "commands.apoli.list.sources"), (Object[])new Object[]{class_2564.method_37112(powerSources, (class_2561)class_2561.method_30163((String)", "))}));
            class_5250 power = class_2561.method_43470((String)powerType.getIdentifier().toString()).method_10862(class_2583.field_24360.method_10949(powerSourcesOnHover));
            powers.add(power);
            ++powerCount;
        }
        if (powerCount > 0) {
            int currentPowerCount = powerCount;
            source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.list.pass", (Object[])new Object[]{livingTarget.method_5476(), currentPowerCount, class_2564.method_37112((Collection)powers, (class_2561)class_2561.method_30163((String)", "))}), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.list.fail", (Object[])new Object[]{livingTarget.method_5476()}));
        }
        return powerCount;
    }

    private static int hasPower(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection targets = class_2186.method_9317(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        LinkedList<class_1309> processedLivingTargets = new LinkedList<class_1309>();
        for (class_1297 target : targets) {
            class_1309 livingTarget;
            PowerHolderComponent powerHolderComponent;
            if (!(target instanceof class_1309) || !(powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)(livingTarget = (class_1309)target))).hasPower(powerType)) continue;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (processedLivingTargets.size() == 1) {
                source.method_9226(() -> class_2561.method_43471((String)"commands.execute.conditional.pass"), true);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.execute.conditional.pass_count", (Object[])new Object[]{processedLivingTargets.size()}), true);
            }
        } else if (targets.size() == 1) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.execute.conditional.fail"));
        } else {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.execute.conditional.fail_count", (Object[])new Object[]{targets.size()}));
        }
        return processedLivingTargets.size();
    }

    private static int getSourcesFromPower(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 target = class_2186.method_9313(context, (String)"target");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        StringBuilder powerSources = new StringBuilder();
        int powerSourceCount = 0;
        if (!(target instanceof class_1309)) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.sources.fail", (Object[])new Object[]{target.method_5476(), powerType.getName()}));
            return powerSourceCount;
        }
        class_1309 livingTarget = (class_1309)target;
        PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
        for (class_2960 powerSource : powerHolderComponent.getSources(powerType)) {
            if (powerSourceCount > 0) {
                powerSources.append(", ");
            }
            powerSources.append(powerSource.toString());
            ++powerSourceCount;
        }
        if (powerSourceCount > 0) {
            int currentPowerSourceCount = powerSourceCount;
            source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.sources.pass", (Object[])new Object[]{livingTarget.method_5476(), currentPowerSourceCount, powerType.getName(), powerSources}), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.sources.fail", (Object[])new Object[]{livingTarget.method_5476(), powerType.getName()}));
        }
        return powerSourceCount;
    }

    private static int removePower(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection targets = class_2186.method_9317(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        LinkedList<class_1297> nonLivingTargets = new LinkedList<class_1297>();
        LinkedList<class_1309> livingTargets = new LinkedList<class_1309>();
        LinkedList<class_1309> processedLivingTargets = new LinkedList<class_1309>();
        for (class_1297 target : targets) {
            if (!(target instanceof class_1309)) {
                nonLivingTargets.add(target);
                continue;
            }
            class_1309 livingTarget = (class_1309)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            List<class_2960> powerSources = powerHolderComponent.getSources(powerType);
            if (powerSources.isEmpty()) continue;
            for (class_2960 powerSource : powerSources) {
                powerHolderComponent.removePower(powerType, powerSource);
            }
            powerHolderComponent.sync();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (processedLivingTargets.size() == 1) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.remove.success.single", (Object[])new Object[]{((class_1309)processedLivingTargets.getFirst()).method_5476(), powerType.getName()}), true);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.remove.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName()}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.remove.fail.single", (Object[])new Object[]{((class_1309)livingTargets.getFirst()).method_5476(), powerType.getName()}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.remove.fail.multiple", (Object[])new Object[]{powerType.getName()}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.remove.invalid_entity", (Object[])new Object[]{((class_1297)nonLivingTargets.getFirst()).method_5476()}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.remove.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int clearAllPowers(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection targets = class_2186.method_9317(context, (String)"targets");
        LinkedList<class_1297> nonLivingTargets = new LinkedList<class_1297>();
        LinkedList<class_1309> livingTargets = new LinkedList<class_1309>();
        LinkedList<class_1309> processedLivingTargets = new LinkedList<class_1309>();
        int clearedPowers = 0;
        for (class_1297 target : targets) {
            if (!(target instanceof class_1309)) {
                nonLivingTargets.add(target);
                continue;
            }
            class_1309 livingTarget = (class_1309)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            Set<PowerType<?>> powerTypes = powerHolderComponent.getPowerTypes(false);
            if (powerTypes.isEmpty()) continue;
            for (PowerType<?> powerType : powerTypes) {
                List<class_2960> powerSources = powerHolderComponent.getSources(powerType);
                powerSources.forEach(powerHolderComponent::removeAllPowersFromSource);
            }
            powerHolderComponent.sync();
            clearedPowers += powerTypes.size();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            int currentClearedPowers = clearedPowers;
            if (processedLivingTargets.size() == 1) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.clear.success.single", (Object[])new Object[]{((class_1309)processedLivingTargets.getFirst()).method_5476(), currentClearedPowers}), true);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.apoli.clear.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), currentClearedPowers}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.clear.fail.single", (Object[])new Object[]{((class_1309)livingTargets.getFirst()).method_5476()}));
            } else {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.apoli.clear.fail.multiple"));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.clear.invalid_entity", (Object[])new Object[]{((class_1297)nonLivingTargets.getFirst()).method_5476()}));
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.apoli.clear.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return clearedPowers;
    }
}

