/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.mixin.entity.common;

import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.sync.ComponentPacketWriter;
import dev.onyxstudios.cca.internal.entity.CardinalComponentsEntity;
import dev.onyxstudios.cca.internal.entity.CardinalEntityInternals;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements ComponentProvider {
    @Unique
    private ComponentContainer components;
    @Shadow
    public Level f_19853_;

    @Shadow
    public abstract int m_19879_();

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void initDataTracker(CallbackInfo ci) {
        this.components = CardinalEntityInternals.createEntityComponentContainer((Entity)this);
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    private void toTag(CompoundTag inputTag, CallbackInfoReturnable<CompoundTag> cir) {
        this.components.toTag((CompoundTag)cir.getReturnValue());
    }

    @Inject(method={"readNbt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V", shift=At.Shift.AFTER)})
    private void fromTag(CompoundTag tag, CallbackInfo ci) {
        this.components.fromTag(tag);
    }

    @Nonnull
    public ComponentContainer getComponentContainer() {
        return this.components;
    }

    public Iterable<ServerPlayer> getRecipientsForComponentSync() {
        Entity holder = (Entity)this;
        if (!this.f_19853_.f_46443_) {
            ArrayDeque<ServerPlayer> watchers = new ArrayDeque<ServerPlayer>(PlayerLookup.tracking((Entity)holder));
            if (holder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)holder;
                if (player.f_8906_ != null) {
                    watchers.addFirst(player);
                }
            }
            return watchers;
        }
        return List.of();
    }

    @Nullable
    public <C extends AutoSyncedComponent> ClientboundCustomPayloadPacket toComponentPacket(ComponentKey<? super C> key, ComponentPacketWriter writer, ServerPlayer recipient) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(this.m_19879_());
        buf.m_130085_(key.getId());
        writer.writeSyncPacket(buf, recipient);
        return new ClientboundCustomPayloadPacket(CardinalComponentsEntity.PACKET_ID, buf);
    }
}

