/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.entity;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.internal.base.ComponentsInternals;
import dev.onyxstudios.cca.internal.entity.CardinalComponentsEntity;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class CcaEntityClientNw {
    public static void initClient() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)CardinalComponentsEntity.PACKET_ID, (client, handler, buffer, res) -> {
                try {
                    int entityId = buffer.readInt();
                    ResourceLocation componentTypeId = buffer.m_130281_();
                    ComponentKey componentType = ComponentRegistry.get((ResourceLocation)componentTypeId);
                    if (componentType == null) {
                        return;
                    }
                    FriendlyByteBuf copy = new FriendlyByteBuf(buffer.copy());
                    client.execute(() -> {
                        try {
                            componentType.maybeGet((Object)Objects.requireNonNull(client.f_91073_).m_6815_(entityId)).filter(c -> c instanceof AutoSyncedComponent).ifPresent(c -> ((AutoSyncedComponent)c).applySyncPacket(copy));
                        }
                        finally {
                            copy.release();
                        }
                    });
                }
                catch (Exception e) {
                    ComponentsInternals.LOGGER.error("Error while reading entity components from network", (Throwable)e);
                    throw e;
                }
            });
        }
    }
}

