/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.entity;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import dev.onyxstudios.cca.api.v3.entity.PlayerCopyCallback;
import dev.onyxstudios.cca.api.v3.entity.PlayerSyncCallback;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import dev.onyxstudios.cca.api.v3.entity.TrackingStartCallback;
import dev.onyxstudios.cca.internal.entity.SwitchablePlayerEntity;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;

public final class CardinalComponentsEntity {
    public static final ResourceLocation PACKET_ID = new ResourceLocation("cardinal-components", "entity_sync");

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            PlayerSyncCallback.EVENT.register(player -> CardinalComponentsEntity.syncEntityComponents(player, (Entity)player));
            TrackingStartCallback.EVENT.register(CardinalComponentsEntity::syncEntityComponents);
        }
        PlayerCopyCallback.EVENT.register(CardinalComponentsEntity::copyData);
    }

    private static void copyData(ServerPlayer original, ServerPlayer clone, boolean lossless) {
        boolean keepInventory = original.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || clone.m_5833_();
        Set keys = ((ComponentProvider)original).getComponentContainer().keys();
        for (ComponentKey key : keys) {
            CardinalComponentsEntity.copyData(original, clone, lossless, keepInventory, key, !((SwitchablePlayerEntity)original).cca$isSwitchingCharacter());
        }
    }

    private static <C extends Component> void copyData(ServerPlayer original, ServerPlayer clone, boolean lossless, boolean keepInventory, ComponentKey<C> key, boolean sameCharacter) {
        Component from = key.get((Object)original);
        Component to = key.get((Object)clone);
        RespawnCopyStrategy.get(key).copyForRespawn(from, to, lossless, keepInventory, sameCharacter);
    }

    private static void syncEntityComponents(ServerPlayer player, Entity tracked) {
        ComponentProvider provider = (ComponentProvider)tracked;
        for (ComponentKey key : provider.getComponentContainer().keys()) {
            key.syncWith(player, provider);
        }
    }
}

