/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.server.ItemEntityExtender;
import team.creative.itemphysic.server.ItemPhysicServer;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements ItemEntityExtender {
    @Shadow
    public int f_31987_;
    @Unique
    private boolean swim;
    @Unique
    private boolean burn;

    private ItemEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void hurtInject(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!ItemPhysicServer.hurt((ItemEntity)this, source, amount)) {
            callback.setReturnValue((Object)false);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return ItemPhysicServer.interact((ItemEntity)this, player, hand);
    }

    protected void m_7840_(double height, boolean fall, BlockState state, BlockPos pos) {
        ItemPhysicServer.checkFallDamage((ItemEntity)this, height, fall, state, pos);
        super.m_7840_(height, fall, state, pos);
    }

    public boolean m_204031_(TagKey<Fluid> fluid, double p_204033_) {
        return ItemPhysicServer.updateFluidHeightAndDoFluidPushing((ItemEntity)this, fluid, p_204033_);
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void playerTouchInject(Player player, CallbackInfo info) {
        if (ItemPhysicServer.playerTouch((ItemEntity)this, player)) {
            info.cancel();
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void fireImmuneInject(CallbackInfoReturnable<Boolean> info) {
        if (ItemPhysicServer.fireImmune((ItemEntity)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z")}, require=1)
    public void updatePre(CallbackInfo info) {
        ItemPhysicServer.updatePre((ItemEntity)this, this.f_19796_);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z"), require=1)
    public boolean isInWaterRedirect(ItemEntity entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInLava()Z"), require=1)
    public boolean isInLavaRedirect(ItemEntity entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isNoGravity()Z"), require=1)
    public boolean isNoGravityRedirect(ItemEntity entity) {
        return true;
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=1)}, require=1)
    public void update(CallbackInfo info) {
        ItemPhysicServer.update((ItemEntity)this);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"), require=3)
    public void setDeltaMovementRedirect(ItemEntity entity, Vec3 vec) {
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setEntityRepresentation(Lnet/minecraft/world/entity/Entity;)V")}, require=1)
    private void onSyncedDataUpdated(EntityDataAccessor<?> accessor, CallbackInfo callback) {
        this.swim = ItemPhysic.CONFIG.general.swimmingItems.canPass(((ItemEntity)this).m_32055_());
        this.burn = ItemPhysic.CONFIG.general.burningItems.canPass(((ItemEntity)this).m_32055_());
    }

    @Override
    public boolean canBurn() {
        return this.burn;
    }

    @Override
    public boolean canSwim() {
        return this.swim;
    }
}

