/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.surfacebuilders;

import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;

public class LuminousGroveSurfaceBuilder
extends BiolithSurfaceBuilder {
    private final BlockState topMaterial;
    private final BlockState midMaterial;
    private final BlockState lowMaterial;

    public LuminousGroveSurfaceBuilder(BlockState topMaterial, BlockState midMaterial, BlockState lowMaterial) {
        this.topMaterial = topMaterial;
        this.midMaterial = midMaterial;
        this.lowMaterial = lowMaterial;
    }

    public void generate(BiomeManager biomeAccess, BlockColumn column, RandomSource rand, ChunkAccess chunk, Biome biome, int x, int z, int vHeight, int seaLevel) {
        BlockPos pos = new BlockPos(x, -128, z);
        boolean inAir = false;
        for (int y = chunk.m_151558_() - 6; y >= seaLevel - 1; --y) {
            BlockState state = column.m_183556_(y);
            if (state.m_60795_()) {
                inAir = true;
                continue;
            }
            if (inAir && state.m_60713_(this.lowMaterial.m_60734_()) && super.filterBiome(biomeAccess.m_204214_(pos.m_175288_(y)))) {
                column.m_183639_(y, rand.m_188501_() < 0.99f ? this.topMaterial : this.midMaterial);
            }
            inAir = false;
        }
    }

    public boolean filterBiome(Holder<Biome> biome) {
        return biome.m_203656_(BiomeTags.f_207612_);
    }
}

