/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.attributizer.networking;

import jackiecrazy.attributizer.ArmorAttributizer;
import jackiecrazy.attributizer.ItemAttributeMod;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncArmorTagDataPacket {
    private static final FriendlyByteBuf.Writer<TagKey<Item>> item = (f, item) -> f.m_130085_(item.f_203868_());
    private static final FriendlyByteBuf.Writer<List<ItemAttributeMod[]>> info = (f, info) -> f.m_236828_((Collection)info, (ff, aa) -> {
        for (ItemAttributeMod a : aa) {
            f.m_130085_(ForgeRegistries.ATTRIBUTES.getKey((Object)a.attribute));
            f.m_130077_(a.uuid);
            f.writeDouble(a.modify);
            f.writeInt(a.operation.ordinal());
        }
    });
    private static final FriendlyByteBuf.Reader<TagKey<Item>> ritem = f -> ItemTags.create((ResourceLocation)f.m_130281_());
    private static final FriendlyByteBuf.Reader<List<ItemAttributeMod[]>> rinfo = f -> f.m_236845_(ff -> {
        ItemAttributeMod[] ret = new ItemAttributeMod[4];
        for (int x = 0; x < ret.length; ++x) {
            ret[x] = new ItemAttributeMod((Attribute)ForgeRegistries.ATTRIBUTES.getValue(ff.m_130281_()), ff.m_130259_(), ff.readDouble(), ItemAttributeMod.Operation.values()[ff.readInt()]);
        }
        return ret;
    });
    private final Map<TagKey<Item>, List<ItemAttributeMod[]>> map;

    public SyncArmorTagDataPacket(Map<TagKey<Item>, List<ItemAttributeMod[]>> map) {
        this.map = map;
    }

    public static class Handler
    implements BiConsumer<SyncArmorTagDataPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(SyncArmorTagDataPacket updateClientPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            if (contextSupplier.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                contextSupplier.get().enqueueWork(() -> ArmorAttributizer.clientTagOverride(updateClientPacket.map));
            }
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, SyncArmorTagDataPacket> {
        @Override
        public SyncArmorTagDataPacket apply(FriendlyByteBuf packetBuffer) {
            return new SyncArmorTagDataPacket(packetBuffer.m_236847_(ritem, rinfo));
        }
    }

    public static class Encoder
    implements BiConsumer<SyncArmorTagDataPacket, FriendlyByteBuf> {
        @Override
        public void accept(SyncArmorTagDataPacket packet, FriendlyByteBuf packetBuffer) {
            packetBuffer.m_236831_(packet.map, item, info);
        }
    }
}

