/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.forge;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.events.AddItemGroupEntriesEvent;
import com.faboslav.friendsandfoes.common.events.RegisterVillagerTradesEvent;
import com.faboslav.friendsandfoes.common.events.block.RegisterBlockSetTypeEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterFlammabilityEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterReloadListenerEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.SetupEvent;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesStructurePoolElements;
import com.faboslav.friendsandfoes.common.util.CustomRaidMember;
import com.faboslav.friendsandfoes.common.util.ServerWorldSpawnersUtil;
import com.faboslav.friendsandfoes.common.world.spawner.IceologerSpawner;
import com.faboslav.friendsandfoes.common.world.spawner.IllusionerSpawner;
import com.faboslav.friendsandfoes.forge.FriendsAndFoesForgeClient;
import com.faboslav.friendsandfoes.forge.init.FriendsAndFoesBiomeModifiers;
import com.faboslav.friendsandfoes.forge.mixin.FireBlockAccessor;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="friendsandfoes")
public final class FriendsAndFoesForge {
    public FriendsAndFoesForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        FriendsAndFoes.init();
        FriendsAndFoesBiomeModifiers.BIOME_MODIFIERS.register(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FriendsAndFoesForgeClient.init(modEventBus, eventBus);
        }
        eventBus.addListener(FriendsAndFoesForge::initSpawners);
        eventBus.addListener(FriendsAndFoesForge::onServerAboutToStartEvent);
        eventBus.addListener(FriendsAndFoesForge::onAddVillagerTrades);
        eventBus.addListener(FriendsAndFoesForge::onAddReloadListeners);
        eventBus.addListener(FriendsAndFoesForge::onDatapackSync);
        modEventBus.addListener(FriendsAndFoesForge::onSetup);
        modEventBus.addListener(FriendsAndFoesForge::onRegisterAttributes);
        modEventBus.addListener(FriendsAndFoesForge::onRegisterSpawnRestrictions);
        modEventBus.addListener(FriendsAndFoesForge::onAddItemGroupEntries);
    }

    private static void onSetup(FMLCommonSetupEvent event) {
        SetupEvent.EVENT.invoke(new SetupEvent(arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0)));
        event.enqueueWork(() -> {
            FriendsAndFoes.lateInit();
            if (FriendsAndFoes.getConfig().enableIceologer && FriendsAndFoes.getConfig().enableIceologerInRaids) {
                Raid.RaiderType.create((String)"ICEOLOGER", FriendsAndFoesEntityTypes.ICEOLOGER.get(), (int[])CustomRaidMember.ICEOLOGER_COUNT_IN_WAVE);
            }
            if (FriendsAndFoes.getConfig().enableIllusioner && FriendsAndFoes.getConfig().enableIllusionerInRaids) {
                Raid.RaiderType.create((String)"ILLUSIONER", (EntityType)EntityType.f_20459_, (int[])CustomRaidMember.ILLUSIONER_COUNT_IN_WAVE);
            }
            RegisterBlockSetTypeEvent.EVENT.invoke(new RegisterBlockSetTypeEvent(BlockSetType::m_272115_));
            RegisterFlammabilityEvent.EVENT.invoke(new RegisterFlammabilityEvent((item, igniteOdds, burnOdds) -> ((FireBlockAccessor)Blocks.f_50083_).invokeRegisterFlammableBlock(item, igniteOdds, burnOdds)));
        });
    }

    private static void onAddReloadListeners(AddReloadListenerEvent event) {
        RegisterReloadListenerEvent.EVENT.invoke(new RegisterReloadListenerEvent((id, listener) -> event.addListener(listener)));
    }

    private static void onDatapackSync(OnDatapackSyncEvent event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            if (event.getPlayer() != null) {
                DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent(event.getPlayer()));
            } else {
                event.getPlayerList().m_11314_().forEach(player -> DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent((ServerPlayer)player)));
            }
        }
    }

    private static void onAddVillagerTrades(VillagerTradesEvent event) {
        RegisterVillagerTradesEvent.EVENT.invoke(new RegisterVillagerTradesEvent(event.getType(), (i, listing) -> ((List)event.getTrades().get(i.intValue())).add(listing)));
    }

    private static void onAddItemGroupEntries(BuildCreativeModeTabContentsEvent event) {
        AddItemGroupEntriesEvent.EVENT.invoke(new AddItemGroupEntriesEvent(AddItemGroupEntriesEvent.Type.toType((ResourceKey<CreativeModeTab>)((ResourceKey)BuiltInRegistries.f_279662_.m_7854_((Object)event.getTab()).orElse(null))), event.getTab(), event.hasPermissions(), arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246342_(arg_0)));
    }

    private static void onRegisterAttributes(EntityAttributeCreationEvent event) {
        RegisterEntityAttributesEvent.EVENT.invoke(new RegisterEntityAttributesEvent((entity, builder) -> event.put(entity, builder.m_22265_())));
    }

    private static void onRegisterSpawnRestrictions(SpawnPlacementRegisterEvent event) {
        RegisterEntitySpawnRestrictionsEvent.EVENT.invoke(new RegisterEntitySpawnRestrictionsEvent(FriendsAndFoesForge.registerEntitySpawnRestriction(event)));
    }

    private static RegisterEntitySpawnRestrictionsEvent.Registrar registerEntitySpawnRestriction(final SpawnPlacementRegisterEvent event) {
        return new RegisterEntitySpawnRestrictionsEvent.Registrar(){

            @Override
            public <T extends Mob> void register(EntityType<T> type, RegisterEntitySpawnRestrictionsEvent.Placement<T> placement) {
                event.register(type, placement.location(), placement.heightmap(), placement.predicate(), SpawnPlacementRegisterEvent.Operation.AND);
            }
        };
    }

    private static void initSpawners(LevelEvent.Load event) {
        if (event.getLevel().m_5776_() || ((ServerLevel)event.getLevel()).m_220362_() != BuiltinDimensionTypes.f_223538_) {
            return;
        }
        MinecraftServer server = event.getLevel().m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel world = server.m_129783_();
        if (world == null) {
            return;
        }
        ServerWorldSpawnersUtil.register(world, new IceologerSpawner());
        ServerWorldSpawnersUtil.register(world, new IllusionerSpawner());
    }

    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        FriendsAndFoesStructurePoolElements.init(event.getServer());
    }
}

