/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.api;

import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public interface IFormattableAttribute {
    default public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (this == Attributes.f_22278_ || this == ForgeMod.SWIM_SPEED.get()) {
            return Component.m_237110_((String)"attributeslib.value.percent", (Object[])new Object[]{ItemStack.f_41584_.format(value * 100.0)});
        }
        if (this == Attributes.f_22279_ && IFormattableAttribute.isNullOrAddition(op)) {
            return Component.m_237110_((String)"attributeslib.value.percent", (Object[])new Object[]{ItemStack.f_41584_.format(value * 1000.0)});
        }
        String key = IFormattableAttribute.isNullOrAddition(op) ? "attributeslib.value.flat" : "attributeslib.value.percent";
        return Component.m_237110_((String)key, (Object[])new Object[]{ItemStack.f_41584_.format(IFormattableAttribute.isNullOrAddition(op) ? value : value * 100.0)});
    }

    default public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        Attribute attr = this.ths();
        double value = modif.m_22218_();
        MutableComponent comp = value > 0.0 ? Component.m_237110_((String)"attributeslib.modifier.plus", (Object[])new Object[]{this.toValueComponent(modif.m_22217_(), value, flag), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.BLUE) : Component.m_237110_((String)"attributeslib.modifier.take", (Object[])new Object[]{this.toValueComponent(modif.m_22217_(), value *= -1.0, flag), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.RED);
        return comp.m_7220_(this.getDebugInfo(modif, flag));
    }

    default public Component getDebugInfo(AttributeModifier modif, TooltipFlag flag) {
        Component debugInfo = CommonComponents.f_237098_;
        if (flag.m_7050_()) {
            double advValue = (double)(modif.m_22217_() == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1 : 0) + modif.m_22218_();
            String valueStr = ItemStack.f_41584_.format(advValue);
            String txt = switch (modif.m_22217_()) {
                default -> throw new IncompatibleClassChangeError();
                case AttributeModifier.Operation.ADDITION -> {
                    if (advValue > 0.0) {
                        yield String.format("[+%s]", valueStr);
                    }
                    yield String.format("[%s]", valueStr);
                }
                case AttributeModifier.Operation.MULTIPLY_BASE -> {
                    if (advValue > 0.0) {
                        yield String.format("[+%sx]", valueStr);
                    }
                    yield String.format("[%sx]", valueStr);
                }
                case AttributeModifier.Operation.MULTIPLY_TOTAL -> String.format("[x%s]", valueStr);
            };
            debugInfo = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)txt).m_130940_(ChatFormatting.GRAY));
        }
        return debugInfo;
    }

    @Nullable
    default public UUID getBaseUUID() {
        if (this == Attributes.f_22281_) {
            return AttributeHelper.BASE_ATTACK_DAMAGE;
        }
        if (this == Attributes.f_22283_) {
            return AttributeHelper.BASE_ATTACK_SPEED;
        }
        if (this == ForgeMod.ENTITY_REACH.get()) {
            return AttributeHelper.BASE_ENTITY_REACH;
        }
        return null;
    }

    default public MutableComponent toBaseComponent(double value, double entityBase, boolean merged, TooltipFlag flag) {
        Attribute attr = this.ths();
        Component debugInfo = CommonComponents.f_237098_;
        if (flag.m_7050_() && !merged) {
            debugInfo = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"attributeslib.adv.base", (Object[])new Object[]{ItemStack.f_41584_.format(entityBase), ItemStack.f_41584_.format(value - entityBase)}).m_130940_(ChatFormatting.GRAY));
        }
        MutableComponent comp = Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.f_41584_.format(value), Component.m_237115_((String)attr.m_22087_())});
        return comp.m_7220_(debugInfo);
    }

    default public double getBonusBaseValue(ItemStack stack) {
        if (this == Attributes.f_22281_) {
            return EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
        }
        return 0.0;
    }

    default public void addBonusTooltips(ItemStack stack, Consumer<Component> tooltip, TooltipFlag flag) {
        if (this == Attributes.f_22281_) {
            float sharpness = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
            Component debugInfo = CommonComponents.f_237098_;
            if (flag.m_7050_()) {
                debugInfo = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"attributeslib.adv.sharpness_bonus", (Object[])new Object[]{Float.valueOf(sharpness)}).m_130940_(ChatFormatting.GRAY));
            }
            MutableComponent comp = AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"attribute.modifier.plus.0", (Object[])new Object[]{ItemStack.f_41584_.format(sharpness), Component.m_237115_((String)this.ths().m_22087_())}).m_130940_(ChatFormatting.BLUE));
            tooltip.accept((Component)comp.m_7220_(debugInfo));
        }
    }

    default public Attribute ths() {
        return (Attribute)this;
    }

    public static MutableComponent toComponent(Attribute attr, AttributeModifier modif, TooltipFlag flag) {
        return ((IFormattableAttribute)attr).toComponent(modif, flag);
    }

    public static MutableComponent toValueComponent(Attribute attr, AttributeModifier.Operation op, double value, TooltipFlag flag) {
        return ((IFormattableAttribute)attr).toValueComponent(op, value, flag);
    }

    public static MutableComponent toBaseComponent(Attribute attr, double value, double entityBase, boolean merged, TooltipFlag flag) {
        return ((IFormattableAttribute)attr).toBaseComponent(value, entityBase, merged, flag);
    }

    public static boolean isNullOrAddition(@Nullable AttributeModifier.Operation op) {
        return op == null || op == AttributeModifier.Operation.ADDITION;
    }
}

