/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.util;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.util.HarvestContext;
import io.github.apace100.apoli.util.SavedBlockPosition;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class HarvestContextStack {
    private static final int MAX_DEPTH = 1024;
    private static final ThreadLocal<Deque<SavedContext>> CONTEXT_STACK = ThreadLocal.withInitial(ArrayDeque::new);

    public static void pushCurrentContext() {
        SavedBlockPosition currentBlockPos = HarvestContext.getBlockPosition();
        Boolean currentCanHarvest = HarvestContext.getCanHarvest();
        if (currentBlockPos != null && currentCanHarvest != null) {
            Deque<SavedContext> stack = CONTEXT_STACK.get();
            if (stack.size() >= 1024) {
                MedievalOrigins.LOG.warn("HarvestContextStack exceeded max depth ({}), clearing to prevent memory leak. This may indicate an issue with nested block breaking.", (Object)1024);
                stack.clear();
                return;
            }
            stack.push(new SavedContext((ServerLevel)currentBlockPos.m_61175_(), currentBlockPos.m_61176_(), currentCanHarvest));
        }
    }

    public static void popAndRestoreContext() {
        Deque<SavedContext> stack = CONTEXT_STACK.get();
        if (!stack.isEmpty()) {
            SavedContext previous = stack.pop();
            HarvestContext.setBlockPosition((ServerLevel)previous.level(), (BlockPos)previous.pos());
            HarvestContext.setCanHarvest((Boolean)previous.canHarvest());
        }
    }

    public static void clear() {
        CONTEXT_STACK.get().clear();
    }

    private record SavedContext(ServerLevel level, BlockPos pos, boolean canHarvest) {
    }
}

