/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.util;

import dev.muon.medievalorigins.compat.FTBTeamsUtils;
import dev.muon.medievalorigins.platform.Services;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AllianceUtil {
    private static final int MAX_OWNERSHIP_DEPTH = 3;

    public static UUID getPlayerAffiliationIdRecursive(Entity entity) {
        return AllianceUtil.getPlayerAffiliationIdRecursiveInternal(entity, 3);
    }

    private static UUID getPlayerAffiliationIdRecursiveInternal(Entity entity, int currentDepth) {
        if (entity == null || currentDepth <= 0) {
            return null;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_20148_();
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            LivingEntity owner = ownable.m_269323_();
            if (owner instanceof Player) {
                Player ownerPlayer = (Player)owner;
                return ownerPlayer.m_20148_();
            }
            return AllianceUtil.getPlayerAffiliationIdRecursiveInternal((Entity)owner, currentDepth - 1);
        }
        return null;
    }

    public static boolean areEntitiesAlliedByFTBTeams(UUID affiliationId1, UUID affiliationId2, Level world) {
        if (affiliationId1 == null || affiliationId2 == null) {
            return false;
        }
        if (affiliationId1.equals(affiliationId2)) {
            return true;
        }
        if (Services.PLATFORM.isModLoaded("ftbteams")) {
            return FTBTeamsUtils.arePlayersInSameTeam(affiliationId1, affiliationId2, world);
        }
        return false;
    }
}

