/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CustomDeathSoundPower
extends Power {
    private final SoundEvent sound;
    private final boolean muted;
    private final float volume;
    private final float pitch;

    public CustomDeathSoundPower(PowerType<?> type, LivingEntity entity, SoundEvent sound, boolean muted, float volume, float pitch) {
        super(type, entity);
        this.sound = sound;
        this.muted = muted;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void playDeathSound(Entity entity) {
        RandomSource randomSource;
        if (this.muted || this.sound == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            randomSource = living.m_217043_();
        } else {
            randomSource = entity.m_9236_().f_46441_;
        }
        RandomSource random = randomSource;
        float randomPitch = (random.m_188501_() - random.m_188501_()) * 0.2f + this.pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_5496_(this.sound, this.volume, randomPitch);
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound, entity.m_5720_(), this.volume, randomPitch);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound, entity.m_5720_(), this.volume, randomPitch);
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(MedievalOrigins.loc("custom_death_sound"), new SerializableData().add("sound", SerializableDataTypes.SOUND_EVENT).add("muted", SerializableDataTypes.BOOLEAN, (Object)false).add("volume", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("pitch", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)), data -> (type, entity) -> new CustomDeathSoundPower((PowerType<?>)type, (LivingEntity)entity, (SoundEvent)data.get("sound"), (Boolean)data.get("muted"), ((Float)data.get("volume")).floatValue(), ((Float)data.get("pitch")).floatValue())).allowCondition();
    }
}

