/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.muon.medievalorigins.power.EdibleItemPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Item.class}, priority=1500)
public class ItemMixin {
    @ModifyExpressionValue(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEdible()Z")})
    private boolean makeEdible(boolean original, Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return original || PowerHolderComponent.hasPower((Entity)player, EdibleItemPower.class, power -> power.doesApply(level, stack));
    }

    @ModifyExpressionValue(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodProperties;canAlwaysEat()Z")})
    private boolean makeEdibleWhenPlayerFull(boolean original, Level level, Player player, InteractionHand hand) {
        return original || PowerHolderComponent.hasPower((Entity)player, EdibleItemPower.class, power -> power.getFoodComponent() != null && power.getFoodComponent().m_38747_());
    }

    @ModifyExpressionValue(method={"finishUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;isEdible()Z")})
    private boolean triggerEat(boolean original, @Local(argsOnly=true) LivingEntity entity, @Local(argsOnly=true) Level level) {
        InteractionHand hand = entity.m_7655_();
        return original || PowerHolderComponent.hasPower((Entity)entity, EdibleItemPower.class, power -> power.doesApply(level, entity.m_21120_(hand)));
    }

    @WrapOperation(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getFoodProperties(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/food/FoodProperties;")}, remap=false)
    private FoodProperties injectCustomFoodProperties(ItemStack instance, LivingEntity livingEntity, Operation<FoodProperties> original, @Local(argsOnly=true) Player player, @Local(argsOnly=true) Level level, @Local(argsOnly=true) InteractionHand hand) {
        FoodProperties originalFood = (FoodProperties)original.call(new Object[]{instance, livingEntity});
        if (originalFood != null) {
            return originalFood;
        }
        ItemStack stack = player.m_21120_(hand);
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)player, EdibleItemPower.class)) {
            if (!power.doesApply(level, stack)) continue;
            return power.getFoodComponent();
        }
        return null;
    }
}

