/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.compat;

import dev.muon.medievalorigins.MedievalOrigins;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.network.ClientboundUpdateCastingState;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnCastStarted;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnClientCast;
import io.redspace.ironsspellbooks.network.spell.ClientboundSyncTargetingData;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.entity.PartEntity;

public class IronsSpellbooksUtils {
    private static final Map<UUID, ContinuousCastData> CONTINUOUS_CASTS = new HashMap<UUID, ContinuousCastData>();

    public static void castSpell(Entity entity, ResourceLocation spellId, int powerLevel, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
        AbstractSpell spell;
        if (entity.m_9236_().m_5776_() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity caster = (LivingEntity)entity;
        ResourceLocation spellResourceLocation = spellId;
        if ("minecraft".equals(spellResourceLocation.m_135827_())) {
            spellResourceLocation = new ResourceLocation("irons_spellbooks", spellResourceLocation.m_135815_());
        }
        if ((spell = SpellRegistry.getSpell((ResourceLocation)spellResourceLocation)) == null || "none".equals(spell.getSpellName())) {
            MedievalOrigins.LOG.info("No valid spell found for resource location " + String.valueOf(spellResourceLocation));
            return;
        }
        IronsSpellbooksUtils.castSpell(caster, spell, powerLevel, null, castTime, manaCost, continuousCost, costInterval);
    }

    public static void castSpellOnTarget(Entity actor, Entity target, ResourceLocation spellId, int powerLevel, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
        AbstractSpell spell;
        LivingEntity caster;
        block7: {
            block6: {
                if (!(actor instanceof LivingEntity)) break block6;
                caster = (LivingEntity)actor;
                if (target instanceof LivingEntity) break block7;
            }
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (actor.m_9236_().m_5776_() || target.m_9236_().m_5776_()) {
            return;
        }
        ResourceLocation spellResourceLocation = spellId;
        if ("minecraft".equals(spellResourceLocation.m_135827_())) {
            spellResourceLocation = new ResourceLocation("irons_spellbooks", spellResourceLocation.m_135815_());
        }
        if ((spell = SpellRegistry.getSpell((ResourceLocation)spellResourceLocation)) == null || "none".equals(spell.getSpellName())) {
            MedievalOrigins.LOG.warn("No valid spell found for resource location: {}", (Object)spellResourceLocation);
            return;
        }
        IronsSpellbooksUtils.castSpell(caster, spell, powerLevel, livingTarget, castTime, manaCost, continuousCost, costInterval);
    }

    public static void castSpell(LivingEntity caster, AbstractSpell spell, int spellLevel, LivingEntity target, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
        if (caster.m_9236_().m_5776_()) {
            return;
        }
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        if (magicData.isCasting()) {
            MedievalOrigins.LOG.debug("SpellTriggerAffix: Entity is still casting {}, forcing spell completion", (Object)magicData.getCastingSpellId());
            AbstractSpell oldSpell = magicData.getCastingSpell().getSpell();
            oldSpell.onCast(caster.m_9236_(), magicData.getCastingSpellLevel(), caster, magicData.getCastSource(), magicData);
            oldSpell.onServerCastComplete(caster.m_9236_(), magicData.getCastingSpellLevel(), caster, magicData, false);
            magicData.resetCastingState();
            magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        }
        if (target != null) {
            MedievalOrigins.LOG.debug("SpellTriggerAffix: Merging target data, target: {}", (Object)target.m_7755_().getString());
            IronsSpellbooksUtils.updateTargetData(caster, (Entity)target, magicData, spell, x -> true);
        }
        if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            MedievalOrigins.LOG.debug("Casting SPELL FOR SERVERPLAYA");
            IronsSpellbooksUtils.castSpellForPlayer(spell, spellLevel, serverPlayer, magicData, castTime, manaCost, continuousCost, costInterval);
        } else if (caster instanceof IMagicEntity) {
            IMagicEntity magicEntity = (IMagicEntity)caster;
            magicEntity.initiateCastSpell(spell, spellLevel);
        } else if (caster instanceof LivingEntity && spell.checkPreCastConditions(caster.m_9236_(), spellLevel, caster, magicData)) {
            spell.onCast(caster.m_9236_(), spellLevel, caster, CastSource.COMMAND, magicData);
            spell.onServerCastComplete(caster.m_9236_(), spellLevel, caster, magicData, false);
        }
    }

    private static void castSpellForPlayer(AbstractSpell spell, int spellLevel, ServerPlayer serverPlayer, MagicData magicData, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
        CastResult castResult = spell.canBeCastedBy(spellLevel, CastSource.COMMAND, magicData, (Player)serverPlayer);
        if (castResult.message != null) {
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(castResult.message));
        }
        if (magicData.isCasting()) {
            MedievalOrigins.LOG.warn("Attempted to trigger affix-cast while player was already casting");
            return;
        }
        if (manaCost.isPresent()) {
            int cost = manaCost.get();
            if (!serverPlayer.m_150110_().f_35937_ && magicData.getMana() < (float)cost) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_mana").m_130940_(ChatFormatting.RED)));
                return;
            }
            if (!serverPlayer.m_150110_().f_35937_) {
                magicData.setMana(magicData.getMana() - (float)cost);
            }
        }
        if (serverPlayer.m_6117_()) {
            serverPlayer.m_5810_();
        }
        int effectiveCastTime = 0;
        if (spell.getCastType() == CastType.CONTINUOUS) {
            effectiveCastTime = spell.getEffectiveCastTime(spellLevel, (LivingEntity)serverPlayer);
        }
        if (castTime.isPresent()) {
            effectiveCastTime = castTime.get();
        }
        if (continuousCost && manaCost.isPresent() && !serverPlayer.m_150110_().f_35937_) {
            CONTINUOUS_CASTS.put(serverPlayer.m_20148_(), new ContinuousCastData(manaCost.get(), costInterval, 0));
        }
        magicData.initiateCast(spell, spellLevel, effectiveCastTime, CastSource.COMMAND, "command");
        magicData.setPlayerCastingItem(ItemStack.f_41583_);
        spell.onServerPreCast(serverPlayer.m_9236_(), spellLevel, (LivingEntity)serverPlayer, magicData);
        Messages.sendToPlayer((Object)new ClientboundUpdateCastingState(spell.getSpellId(), spellLevel, effectiveCastTime, CastSource.COMMAND, "command"), (ServerPlayer)serverPlayer);
        Messages.sendToPlayersTrackingEntity((Object)new ClientboundOnCastStarted(serverPlayer.m_20148_(), spell.getSpellId(), spellLevel), (Entity)serverPlayer, (boolean)true);
        ICastData iCastData = magicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            TargetEntityCastData targetingData = (TargetEntityCastData)iCastData;
        } else {
            MedievalOrigins.LOG.warn("Tried to merge Targeting Data but was overridden. Current cast data for spell {}: {}", (Object)magicData.getCastingSpellId(), (Object)magicData.getAdditionalCastData().getClass().getName());
        }
        if (effectiveCastTime == 0) {
            spell.onCast(serverPlayer.m_9236_(), spellLevel, (LivingEntity)serverPlayer, CastSource.COMMAND, magicData);
            Messages.sendToPlayer((Object)new ClientboundOnClientCast(spell.getSpellId(), spellLevel, CastSource.COMMAND, magicData.getAdditionalCastData()), (ServerPlayer)serverPlayer);
        }
    }

    public static void onSpellTick(ServerPlayer player, MagicData magicData) {
        UUID playerId = player.m_20148_();
        ContinuousCastData data = CONTINUOUS_CASTS.get(playerId);
        if (data != null) {
            ++data.ticksElapsed;
            if (data.ticksElapsed >= data.costInterval) {
                data.ticksElapsed = 0;
                if (magicData.getMana() >= (float)data.manaCost) {
                    magicData.setMana(magicData.getMana() - (float)data.manaCost);
                    MedievalOrigins.LOG.debug("Draining mana: " + data.manaCost + ". Remaining mana: " + magicData.getMana());
                } else {
                    Utils.serverSideCancelCast((ServerPlayer)player);
                    CONTINUOUS_CASTS.remove(playerId);
                }
            }
        }
    }

    public static void onSpellEnd(ServerPlayer player) {
        CONTINUOUS_CASTS.remove(player.m_20148_());
    }

    public static double getSpellPowerForSchool(String magicSchoolStr, LivingEntity actor) {
        String translatedSchool;
        Map<String, String> schoolTranslationMap = Map.of("frost", "ice", "healing", "holy", "arcane", "ender", "soul", "blood");
        ResourceLocation schoolResourceLocation = new ResourceLocation((String)(magicSchoolStr.contains(":") ? magicSchoolStr : "irons_spellbooks:" + magicSchoolStr));
        SchoolType magicSchool = SchoolRegistry.getSchool((ResourceLocation)schoolResourceLocation);
        if (magicSchool == null && (translatedSchool = schoolTranslationMap.get(magicSchoolStr)) != null) {
            schoolResourceLocation = new ResourceLocation((String)(translatedSchool.contains(":") ? translatedSchool : "irons_spellbooks:" + translatedSchool));
            magicSchool = SchoolRegistry.getSchool((ResourceLocation)schoolResourceLocation);
        }
        if (magicSchool != null) {
            return magicSchool.getPowerFor(actor);
        }
        MedievalOrigins.LOG.info("No valid Magic School found for type " + magicSchoolStr);
        return 0.0;
    }

    public static void updateTargetData(LivingEntity caster, Entity entityHit, MagicData playerMagicData, AbstractSpell spell, Predicate<LivingEntity> filter) {
        LivingEntity livingParent;
        PartEntity partEntity;
        Entity parent;
        LivingEntity livingEntity;
        LivingEntity livingTarget = null;
        if (entityHit instanceof LivingEntity && filter.test(livingEntity = (LivingEntity)entityHit)) {
            livingTarget = livingEntity;
        } else if (entityHit instanceof PartEntity && (parent = (partEntity = (PartEntity)entityHit).getParent()) instanceof LivingEntity && filter.test(livingParent = (LivingEntity)parent)) {
            livingTarget = livingParent;
        }
        if (livingTarget != null) {
            ServerPlayer serverPlayer;
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(livingTarget));
            if (caster instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)caster;
                if (spell.getCastType() != CastType.INSTANT) {
                    Messages.sendToPlayer((Object)new ClientboundSyncTargetingData(livingTarget, spell), (ServerPlayer)serverPlayer);
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success", (Object[])new Object[]{livingTarget.m_5446_().getString(), spell.getDisplayName((Player)serverPlayer)}).m_130940_(ChatFormatting.GREEN)));
            }
            if (livingTarget instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingTarget;
                Utils.sendTargetedNotification((ServerPlayer)serverPlayer, (LivingEntity)caster, (AbstractSpell)spell);
            }
        } else if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_target").m_130940_(ChatFormatting.RED)));
        }
    }

    private static class ContinuousCastData {
        final int manaCost;
        final int costInterval;
        int ticksElapsed;

        ContinuousCastData(int manaCost, int costInterval, int ticksElapsed) {
            this.manaCost = manaCost;
            this.costInterval = costInterval;
            this.ticksElapsed = ticksElapsed;
        }
    }
}

