/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.entity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import dev.muon.medievalorigins.entity.SummonTracker;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CommandSummonsAction {
    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("command_summons"), new SerializableData().add("command", SerializableDataTypes.STRING), CommandSummonsAction::action);
    }

    public static void action(SerializableData.Instance data, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        String command = data.getString("command");
        Collection<ISummon> summons = SummonTracker.getSummonsForOwner(living.m_20148_());
        switch (command.toLowerCase()) {
            case "sit": {
                summons.forEach(summon -> {
                    summon.setOrderedToSit(true);
                    if (summon.getSelfAsMob() != null) {
                        summon.getSelfAsMob().m_21573_().m_26573_();
                    }
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"message.medievalorigins.summon.sit"), true);
                    }
                });
                break;
            }
            case "follow": {
                summons.forEach(summon -> {
                    summon.setOrderedToSit(false);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"message.medievalorigins.summon.follow"), true);
                    }
                });
                break;
            }
            case "come": {
                summons.forEach(summon -> {
                    summon.getSelfAsMob().m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"message.medievalorigins.summon.come"), true);
                    }
                });
            }
        }
    }
}

