/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaycastBetweenAction {
    public static ActionFactory<Tuple<Entity, Entity>> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("raycast_between"), new SerializableData().add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE).add("spacing", SerializableDataTypes.DOUBLE, (Object)0.5), RaycastBetweenAction::action);
    }

    public static void action(SerializableData.Instance data, Tuple<Entity, Entity> entities) {
        Entity actor = (Entity)entities.m_14418_();
        Entity target = (Entity)entities.m_14419_();
        if (actor == null || target == null || actor.m_9236_().m_5776_()) {
            return;
        }
        ParticleOptions particle = (ParticleOptions)data.get("particle");
        double spacing = data.getDouble("spacing");
        RaycastBetweenAction.createParticlesAtHitPos(actor, (HitResult)new EntityHitResult(target), particle, spacing);
    }

    protected static Vec3 createDirectionVector(Vec3 pos1, Vec3 pos2) {
        return new Vec3(pos2.m_7096_() - pos1.m_7096_(), pos2.m_7098_() - pos1.m_7098_(), pos2.m_7094_() - pos1.m_7094_()).m_82541_();
    }

    protected static void createParticlesAtHitPos(Entity entity, HitResult hitResult, ParticleOptions particle, double spacing) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        double distanceTo = hitResult.m_82448_(entity);
        for (double d = spacing; d < distanceTo; d += spacing) {
            double lerpValue = Mth.m_14008_((double)(d / distanceTo), (double)0.0, (double)1.0);
            ((ServerLevel)entity.m_9236_()).m_8767_(particle, Mth.m_14139_((double)lerpValue, (double)entity.m_146892_().m_7096_(), (double)hitResult.m_82450_().m_7096_()), Mth.m_14139_((double)lerpValue, (double)entity.m_146892_().m_7098_(), (double)hitResult.m_82450_().m_7098_()), Mth.m_14139_((double)lerpValue, (double)entity.m_146892_().m_7094_(), (double)hitResult.m_82450_().m_7094_()), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

