/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.jei;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.client.ClientUtils;
import com.christofmeg.justenoughbreeding.jei.AllayDuplicationCategory;
import com.christofmeg.justenoughbreeding.jei.BreedingCategory;
import com.christofmeg.justenoughbreeding.jei.TamingCategory;
import com.christofmeg.justenoughbreeding.jei.TemperCategory;
import com.christofmeg.justenoughbreeding.jei.TransformationCategory;
import com.christofmeg.justenoughbreeding.jei.TrustingCategory;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TamingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonClientUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.RecipeType;

public class JEIUtils {
    public static void registerRecipes(IRecipeRegistration registration) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel != null) {
            ArrayList<AllayDuplicationRecipe> allayDuplicationRecipes = new ArrayList<AllayDuplicationRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.ALLAY_DUPLICATION_PROVIDER_TYPE.get()));
            allayDuplicationRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (AllayDuplicationRecipe allayDuplicationRecipe : allayDuplicationRecipes) {
                if (!JustEnoughBreeding.isModLoaded(allayDuplicationRecipe.jsonModID).booleanValue() || allayDuplicationRecipe.entityType == null || allayDuplicationRecipe.inputStack.m_43947_()) continue;
                registration.addRecipes(AllayDuplicationCategory.TYPE, Collections.singletonList(allayDuplicationRecipe));
            }
            ArrayList<BreedingRecipe> breedingRecipes = new ArrayList<BreedingRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.BREEDING_PROVIDER_TYPE.get()));
            breedingRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (BreedingRecipe breedingRecipe : breedingRecipes) {
                if (!JustEnoughBreeding.isModLoaded(breedingRecipe.jsonModID).booleanValue() || breedingRecipe.entityType == null || breedingRecipe.inputStack.m_43947_()) continue;
                registration.addRecipes(BreedingCategory.TYPE, Collections.singletonList(breedingRecipe));
            }
            ArrayList<TamingRecipe> arrayList = new ArrayList<TamingRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TAMING_PROVIDER_TYPE.get()));
            arrayList.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (TamingRecipe tamingRecipe : arrayList) {
                if (!JustEnoughBreeding.isModLoaded(tamingRecipe.jsonModID).booleanValue() || tamingRecipe.entityType == null || tamingRecipe.inputStack.m_43947_()) continue;
                registration.addRecipes(TamingCategory.TYPE, Collections.singletonList(tamingRecipe));
            }
            ArrayList<TemperRecipe> arrayList2 = new ArrayList<TemperRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TEMPER_PROVIDER_TYPE.get()));
            arrayList2.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (TemperRecipe temperRecipe : arrayList2) {
                if (!JustEnoughBreeding.isModLoaded(temperRecipe.jsonModID).booleanValue() || temperRecipe.entityType == null || temperRecipe.inputStack.m_43947_()) continue;
                registration.addRecipes(TemperCategory.TYPE, Collections.singletonList(temperRecipe));
            }
            ArrayList<TransformationRecipe> arrayList3 = new ArrayList<TransformationRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TRANSFORMATION_PROVIDER_TYPE.get()));
            arrayList3.sort(Comparator.comparing(r -> r.outputEntityType == null ? r.fileName : r.outputEntityType.m_147048_()));
            for (TransformationRecipe recipe : arrayList3) {
                if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.inputEntityType == null || recipe.outputEntityType == null || recipe.inputStack.m_43947_()) continue;
                registration.addRecipes(TransformationCategory.TYPE, Collections.singletonList(recipe));
            }
            ArrayList<TrustingRecipe> arrayList4 = new ArrayList<TrustingRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TRUSTING_PROVIDER_TYPE.get()));
            arrayList4.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (TrustingRecipe recipe : arrayList4) {
                if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.entityType == null || recipe.inputStack.m_43947_()) continue;
                registration.addRecipes(TrustingCategory.TYPE, Collections.singletonList(recipe));
            }
        }
    }

    public static void drawMobSlot(int mobSlotX, int mobSlotY, IDrawableStatic bigSlot, GuiGraphics stack) {
        JEIUtils.draw(bigSlot, stack, mobSlotX, mobSlotY, bigSlot.getHeight(), 0, 0, 1, 25);
        JEIUtils.draw(bigSlot, stack, mobSlotX, mobSlotY + 25, bigSlot.getHeight(), 0, 0, 1, 25);
        JEIUtils.draw(bigSlot, stack, mobSlotX, mobSlotY + 50, bigSlot.getHeight(), 0, 0, 1, 25);
        JEIUtils.draw(bigSlot, stack, mobSlotX, mobSlotY + 55, bigSlot.getHeight(), 0, 20, 1, 6);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 35, mobSlotY, bigSlot.getHeight(), 25, 0, 1, 25);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 35, mobSlotY + 24, bigSlot.getHeight(), 25, 1, 1, 25);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 35, mobSlotY + 49, bigSlot.getHeight(), 25, 1, 1, 25);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 35, mobSlotY + 55, bigSlot.getHeight(), 25, 19, 1, 6);
        JEIUtils.draw(bigSlot, stack, mobSlotX, mobSlotY, bigSlot.getHeight(), 1, 0, 24, 1);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 24, mobSlotY, bigSlot.getHeight(), 1, 0, 24, 1);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 35, mobSlotY, bigSlot.getHeight(), 14, 0, 11, 1);
        JEIUtils.draw(bigSlot, stack, mobSlotX, mobSlotY + 55, bigSlot.getHeight(), 1, 25, 24, 1);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 24, mobSlotY + 55, bigSlot.getHeight(), 1, 25, 24, 1);
        JEIUtils.draw(bigSlot, stack, mobSlotX + 35, mobSlotY + 55, bigSlot.getHeight(), 14, 25, 11, 1);
        int color = CommonClientUtils.getPixelColor(new ResourceLocation("jei", "textures/jei/atlas/gui/output_slot.png"), 13, 13);
        int startX = mobSlotX + 1;
        int startY = mobSlotY + 1;
        int width = 59;
        int height = 79;
        CommonClientUtils.fillSolidColor(stack, startX, startY, width, height, color);
    }

    private static void draw(IDrawableStatic slot, GuiGraphics stack, int mobSlotX, int mobSlotY, int textureSize, int removeFromLeft, int removeFromTop, int selectionX, int selectionY) {
        int removeFromBottom = textureSize - (removeFromTop + selectionY);
        int removeFromRight = textureSize - (removeFromLeft + selectionX);
        slot.draw(stack, mobSlotX, mobSlotY, removeFromTop, removeFromBottom, removeFromLeft, removeFromRight);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, GuiGraphics stack, double mouseX, BaseRecipe recipe) {
        JEIUtils.drawMobNameAndEntity(entityType, stack, mouseX, recipe, 148, 0);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, GuiGraphics stack, double mouseX, BaseRecipe recipe, int availableWidth, int extraX) {
        JEIUtils.drawMobNameAndEntity(entityType, stack, mouseX, recipe, availableWidth, extraX, true);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, GuiGraphics stack, double mouseX, BaseRecipe recipe, int availableWidth, int extraX, boolean input) {
        if (entityType != null) {
            LivingEntity currentLivingEntity;
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent entityName = Component.m_237115_((String)entityType.m_20675_());
            Object entityNameString = entityName.getString();
            if (recipe instanceof BreedingRecipe) {
                BreedingRecipe breedingRecipe = (BreedingRecipe)recipe;
                if (breedingRecipe.needsToBeTamed != null && breedingRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                } else if (breedingRecipe.animalTrusting != null && breedingRecipe.animalTrusting.booleanValue()) {
                    MutableComponent trusting = Component.m_237115_((String)"translation.justenoughbreeding.trusting");
                    entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
                } else if ("tfc".equals(breedingRecipe.jsonModID)) {
                    MutableComponent familiarity = Component.m_237115_((String)"tfc.jade.familiarity");
                    String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                    entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
                }
            } else if (recipe instanceof TransformationRecipe) {
                TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                if (input && transformationRecipe.needsToBeTamed != null && transformationRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                }
            }
            int stringWidth = font.m_92895_((String)entityNameString);
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)Math.max(1, ((String)entityNameString).length());
                int maxCharacters = Math.max(0, (int)((float)availableWidth / pixelWidthPerCharacter));
                entityNameString = ((String)entityNameString).substring(0, Math.min(((String)entityNameString).length(), maxCharacters));
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.m_130674_((String)entityNameString);
                stack.m_280614_(font, abbreviatedEntityName, extraX, 0, DyeColor.BLACK.m_41071_(), false);
            }
            if (recipe instanceof TransformationRecipe) {
                TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                currentLivingEntity = input ? ClientUtils.doRendering(transformationRecipe.inputEntityType, transformationRecipe.inputEntityNbt, true) : ClientUtils.doRendering(transformationRecipe.outputEntityType, transformationRecipe.outputEntityNbt, false);
            } else {
                currentLivingEntity = ClientUtils.doRendering(entityType);
            }
            if (currentLivingEntity != null) {
                if (input) {
                    if (recipe instanceof TransformationRecipe) {
                        TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                        if (transformationRecipe.inputEntityNbt != null) {
                            currentLivingEntity.m_20258_(transformationRecipe.inputEntityNbt);
                        }
                    }
                    if (recipe instanceof AllayDuplicationRecipe) {
                        AllayDuplicationRecipe allayDuplicationRecipe = (AllayDuplicationRecipe)recipe;
                        if (allayDuplicationRecipe.inputEntityNbt != null) {
                            currentLivingEntity.m_20258_(allayDuplicationRecipe.inputEntityNbt);
                        }
                    }
                    if (recipe instanceof BreedingRecipe) {
                        BreedingRecipe breedingRecipe = (BreedingRecipe)recipe;
                        if (breedingRecipe.inputEntityNbt != null) {
                            currentLivingEntity.m_20258_(breedingRecipe.inputEntityNbt);
                        }
                    }
                    if (recipe instanceof TamingRecipe) {
                        TamingRecipe tamingRecipe = (TamingRecipe)recipe;
                        if (tamingRecipe.inputEntityNbt != null) {
                            currentLivingEntity.m_20258_(tamingRecipe.inputEntityNbt);
                        }
                    }
                    if (recipe instanceof TemperRecipe) {
                        TemperRecipe temperRecipe = (TemperRecipe)recipe;
                        if (temperRecipe.inputEntityNbt != null) {
                            currentLivingEntity.m_20258_(temperRecipe.inputEntityNbt);
                        }
                    }
                    if (recipe instanceof TrustingRecipe) {
                        TrustingRecipe trustingRecipe = (TrustingRecipe)recipe;
                        if (trustingRecipe.inputEntityNbt != null) {
                            currentLivingEntity.m_20258_(trustingRecipe.inputEntityNbt);
                        }
                    }
                } else if (recipe instanceof TransformationRecipe) {
                    TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                    if (transformationRecipe.outputEntityNbt != null) {
                        currentLivingEntity.m_20258_(transformationRecipe.outputEntityNbt);
                    }
                }
                CommonClientUtils.renderEntity(stack.m_280168_(), mouseX, currentLivingEntity, 31 + extraX, 89);
            }
        }
    }
}

