/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.setup;

import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.client.gui.ConditionalSlotContainerScreen;
import io.github.wouink.furnish.client.gui.DiskRackScreen;
import io.github.wouink.furnish.client.gui.FurnitureWorkbenchScreen;
import io.github.wouink.furnish.client.gui.LetterScreen;
import io.github.wouink.furnish.client.renderer.DiskRackRenderer;
import io.github.wouink.furnish.client.renderer.FlowerPotRenderer;
import io.github.wouink.furnish.client.renderer.MailboxRenderer;
import io.github.wouink.furnish.client.renderer.PlateRenderer;
import io.github.wouink.furnish.client.renderer.RecycleBinRenderer;
import io.github.wouink.furnish.client.renderer.SeatRenderer;
import io.github.wouink.furnish.client.renderer.ShelfRenderer;
import io.github.wouink.furnish.client.renderer.ShowcaseRenderer;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishRegistries;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class FurnishClient {
    public static void registerBlockRenderTypes() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Red_Bunting.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Yellow_Bunting.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Green_Bunting.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Oak_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Birch_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Jungle_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Spruce_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Acacia_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Dark_Oak_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Crimson_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Warped_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Cherry_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Mangrove_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Bamboo_Shutter.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Recycle_Bin.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Iron_Bars_Top.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Iron_Gate.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Cobweb.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FurnishBlocks.Snow_On_Stairs.get()});
        for (RegistrySupplier<Block> b : FurnishBlocks.Showcases) {
            RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)b.get()});
        }
        for (RegistrySupplier<Block> b : FurnishBlocks.Curtains) {
            RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)b.get()});
        }
        Furnish.LOG.info("Registered Furnish Block Render Types.");
    }

    public static void bindScreensToContainers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)FurnishRegistries.Furniture_Workbench_Container.get()), FurnitureWorkbenchScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)FurnishRegistries.Crate_Container.get()), ConditionalSlotContainerScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)FurnishRegistries.Mailbox_Container.get()), ConditionalSlotContainerScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)FurnishRegistries.Bookshelf_Chest_Container.get()), ConditionalSlotContainerScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)FurnishRegistries.Disk_Rack_Container.get()), DiskRackScreen::new);
        Furnish.LOG.info("Bound Furnish Containers to their Screens.");
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(() -> FurnishRegistries.Seat_Entity.get(), SeatRenderer::new);
        Furnish.LOG.info("Registered Furnish Entities Renderers.");
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FurnishRegistries.Mailbox_BlockEntity.get()), MailboxRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FurnishRegistries.Plate_BlockEntity.get()), PlateRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FurnishRegistries.Shelf_BlockEntity.get()), ShelfRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FurnishRegistries.Showcase_BlockEntity.get()), ShowcaseRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FurnishRegistries.Disk_Rack_BlockEntity.get()), DiskRackRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FurnishRegistries.Recycle_Bin_BlockEntity.get()), RecycleBinRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FurnishRegistries.Flower_Pot_BlockEntity.get()), FlowerPotRenderer::new);
        Furnish.LOG.info("Registered Furnish Blocks Entities Renderers.");
    }

    public static void openLetterGui(ItemStack stack, Player player, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)new LetterScreen(stack, player, hand));
    }

    public static void copyDoorKnockSilencerPack() {
        File resourcePacksDir = new File(".", "resourcepacks");
        File target = new File(resourcePacksDir, "Furnish Door Knock Silencer.zip");
        if (!target.exists()) {
            Furnish.LOG.info("Copying Furnish Door Knock Silencer resource pack to resourcepacks.");
            try {
                int len;
                resourcePacksDir.mkdirs();
                InputStream inputStream = Furnish.class.getResourceAsStream("/assets/furnish/no_door_knock.zip");
                FileOutputStream outputStream = new FileOutputStream(target);
                byte[] buf = new byte[16384];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                inputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isLeaveSnowy(BlockAndTintGetter level, BlockPos pos, boolean includeAir, boolean airBelow) {
        if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50125_)) {
            return true;
        }
        if (level.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13035_)) {
            return FurnishClient.isLeaveSnowy(level, pos.m_7494_(), includeAir, false);
        }
        if (includeAir && !airBelow && level.m_8055_(pos.m_7494_()).m_60795_()) {
            return FurnishClient.isLeaveSnowy(level, pos.m_7494_(), true, true);
        }
        return false;
    }
}

