/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public abstract class FSingleItemRecipe
implements Recipe<Container> {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;

    public FSingleItemRecipe(RecipeType<?> type, RecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, ItemStack result) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = result;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.ingredient);
        return nonNullList;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public static class Serializer<T extends FSingleItemRecipe>
    implements RecipeSerializer<T> {
        final SingleItemMaker<T> factory;

        public Serializer(SingleItemMaker<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_288218_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient"), (boolean)false) : Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"), (boolean)false);
            String string2 = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            int i = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(string2)), i);
            return this.factory.create(recipeId, string, ingredient, itemStack);
        }

        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String string = buffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemStack = buffer.m_130267_();
            return this.factory.create(recipeId, string, ingredient, itemStack);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130070_(((FSingleItemRecipe)recipe).group);
            ((FSingleItemRecipe)recipe).ingredient.m_43923_(buffer);
            buffer.m_130055_(((FSingleItemRecipe)recipe).result);
        }

        public static interface SingleItemMaker<T extends FSingleItemRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
        }
    }
}

