/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.item;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.setup.FurnishClient;
import io.github.wouink.furnish.setup.FurnishRegistries;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class Letter
extends Item {
    public Letter(Item.Properties p) {
        super(p);
    }

    private void openGui(ItemStack stack, Player playerEntity, InteractionHand hand) {
        if (Platform.getEnvironment() != Env.CLIENT) {
            Furnish.LOG.error("Furnish Letter Item - Attempt to call openGui elsewhere than on client.");
            return;
        }
        playerEntity.m_9236_().m_5594_(null, playerEntity.m_20183_(), SoundEvents.f_11713_, SoundSource.PLAYERS, 1.0f, 1.0f);
        FurnishClient.openLetterGui(stack, playerEntity, hand);
    }

    public void m_7373_(ItemStack letter, Level world, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (letter.m_41782_()) {
            CompoundTag letterTag = letter.m_41783_();
            if (letterTag.m_128441_("Author")) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.furnish.letter.author", (Object[])new Object[]{letterTag.m_128461_("Author")}).m_130940_(ChatFormatting.GRAY));
            }
            if (letterTag.m_128441_("Attachment")) {
                ItemStack attachment = ItemStack.m_41712_((CompoundTag)letterTag.m_128469_("Attachment"));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.furnish.letter.attachment", (Object[])new Object[]{attachment.m_41720_().m_41466_()}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public static ItemStack addAttachment(ItemStack letter, ItemStack attachment) {
        CompoundTag letterTag = letter.m_41784_();
        if (!letterTag.m_128441_("Attachment")) {
            CompoundTag attachmentTag = new CompoundTag();
            letterTag.m_128365_("Attachment", (Tag)attachment.m_41739_(attachmentTag));
            letter.m_41751_(letterTag);
            return ItemStack.f_41583_;
        }
        return attachment;
    }

    public static ItemStack removeAttachment(ItemStack letter) {
        CompoundTag letterTag = letter.m_41784_();
        if (letterTag.m_128441_("Attachment")) {
            ItemStack attachment = ItemStack.m_41712_((CompoundTag)letterTag.m_128469_("Attachment"));
            letterTag.m_128473_("Attachment");
            letter.m_41751_(letterTag);
            return attachment;
        }
        return ItemStack.f_41583_;
    }

    public static void signLetter(ItemStack letter, String author) {
        CompoundTag letterTag = letter.m_41784_();
        if (!letterTag.m_128441_("Author")) {
            letterTag.m_128359_("Author", author);
        }
        letter.m_41751_(letterTag);
    }

    public static boolean canEditLetter(ItemStack letter) {
        CompoundTag letterTag = letter.m_41784_();
        return !letterTag.m_128441_("Author");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        ItemStack letter = playerEntity.m_21120_(hand);
        if (playerEntity.m_6047_()) {
            if (hand != InteractionHand.OFF_HAND) {
                ItemStack result = Letter.removeAttachment(letter);
                if (!result.m_41619_()) {
                    playerEntity.m_36356_(result);
                    if (world.m_5776_()) {
                        playerEntity.m_5661_((Component)Component.m_237115_((String)"msg.furnish.letter.attachment_removed"), true);
                        playerEntity.m_5496_((SoundEvent)FurnishRegistries.Detach_From_Letter_Sound.get(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19092_((Object)letter, (boolean)world.m_5776_());
                }
                ItemStack offHandStack = playerEntity.m_21120_(InteractionHand.OFF_HAND);
                if (!offHandStack.m_41619_()) {
                    result = Letter.addAttachment(letter, offHandStack);
                    playerEntity.m_21008_(InteractionHand.OFF_HAND, result);
                    if (result.m_41619_()) {
                        if (world.m_5776_()) {
                            playerEntity.m_5661_((Component)Component.m_237110_((String)"msg.furnish.letter.attachment_added", (Object[])new Object[]{offHandStack.m_41720_().m_41466_()}), true);
                            playerEntity.m_5496_((SoundEvent)FurnishRegistries.Attach_To_Letter_Sound.get(), 1.0f, 1.0f);
                        }
                        return InteractionResultHolder.m_19092_((Object)letter, (boolean)world.m_5776_());
                    }
                }
                return InteractionResultHolder.m_19100_((Object)letter);
            }
            return InteractionResultHolder.m_19100_((Object)letter);
        }
        if (world.m_5776_()) {
            this.openGui(letter, playerEntity, hand);
        }
        return InteractionResultHolder.m_19092_((Object)letter, (boolean)world.m_5776_());
    }
}

