/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.event;

import dev.architectury.event.EventResult;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.SnowOnFence;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class PlaceSnow {
    public static EventResult onSnowLayerUsedOnBlock(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        Level level = player.m_9236_();
        if (level.m_5776_() || player.m_6144_()) {
            return EventResult.pass();
        }
        if (!level.m_46859_(pos.m_7494_())) {
            return EventResult.pass();
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() != Items.f_41979_) {
            return EventResult.pass();
        }
        Item item = heldItem.m_41720_();
        if (!(item instanceof BlockItem)) {
            Furnish.LOG.error("PlaceSnow event: snow item is not a BlockItem??");
            return EventResult.pass();
        }
        BlockItem heldBlock = (BlockItem)item;
        BlockState snow = heldBlock.m_40614_().m_49966_();
        BlockState state = level.m_8055_(pos);
        boolean placed = true;
        if (state.m_60734_() instanceof FenceBlock && snow.m_204336_(FurnishRegistries.PLACE_ON_FENCE)) {
            level.m_7731_(pos.m_7494_(), (BlockState)PlaceSnow.copyFenceProperties(state).m_61124_((Property)SnowOnFence.GROUND, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7495_().m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_().m_7495_(), Direction.UP))), 3);
        } else if (state.m_60734_() instanceof StairBlock && snow.m_204336_(FurnishRegistries.PLACE_ON_STAIRS)) {
            if (state.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM && state.m_61143_((Property)StairBlock.f_56843_) == StairsShape.STRAIGHT) {
                level.m_7731_(pos.m_7494_(), (BlockState)((Block)FurnishBlocks.Snow_On_Stairs.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))), 3);
            }
        } else {
            placed = false;
        }
        if (placed) {
            player.m_6674_(hand);
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                player.m_21008_(hand, heldItem);
            }
            level.m_5594_(null, pos, SoundEvents.f_12482_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return EventResult.pass();
    }

    private static BlockState copyFenceProperties(BlockState fenceBelow) {
        BlockState snowOnFence = ((Block)FurnishBlocks.Snow_On_Fence.get()).m_49966_();
        snowOnFence = (BlockState)snowOnFence.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)fenceBelow.m_61143_((Property)FenceBlock.f_52310_)));
        snowOnFence = (BlockState)snowOnFence.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)fenceBelow.m_61143_((Property)FenceBlock.f_52312_)));
        snowOnFence = (BlockState)snowOnFence.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)fenceBelow.m_61143_((Property)FenceBlock.f_52309_)));
        snowOnFence = (BlockState)snowOnFence.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)fenceBelow.m_61143_((Property)FenceBlock.f_52311_)));
        return snowOnFence;
    }
}

