/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.event;

import dev.architectury.event.EventResult;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.setup.FurnishRegistries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class CyclePainting {
    public static EventResult onPaintingInteract(Player player, Entity entity, InteractionHand hand) {
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return EventResult.pass();
        }
        ItemStack inHand = player.m_21120_(hand);
        if (!inHand.m_41720_().equals(Items.f_42487_) || !inHand.m_204117_(FurnishRegistries.CAN_CYCLE)) {
            return EventResult.pass();
        }
        if (!(entity instanceof Painting)) {
            return EventResult.pass();
        }
        Painting painting = (Painting)entity;
        List<Holder<PaintingVariant>> similarSizeArts = CyclePainting.getSimilarSizeArt(level, (PaintingVariant)painting.m_28554_().m_203334_());
        if (similarSizeArts.isEmpty() || similarSizeArts.size() < 2) {
            player.m_5661_((Component)Component.m_237115_((String)"msg.furnish.cycle_no_painting"), true);
            return EventResult.interruptFalse();
        }
        if (player.m_6144_()) {
            Collections.reverse(similarSizeArts);
        }
        int index = similarSizeArts.indexOf(painting.m_28554_());
        int newVariantIndex = (index + 1) % similarSizeArts.size();
        Furnish.debug("index = " + index + ", newVariantIndex = " + newVariantIndex);
        Holder<PaintingVariant> newVariant = similarSizeArts.get(newVariantIndex);
        painting.m_28464_(newVariant);
        level.m_5594_(null, painting.m_20183_(), SoundEvents.f_12176_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_6674_(hand);
        return EventResult.interruptTrue();
    }

    public static List<Holder<PaintingVariant>> getSimilarSizeArt(Level level, PaintingVariant reference) {
        ArrayList<Holder<PaintingVariant>> similar = new ArrayList<Holder<PaintingVariant>>();
        Iterable allVariants = level.m_7654_().m_206579_().m_175515_(Registries.f_256836_).m_206058_(PaintingVariantTags.f_215870_);
        for (Holder holder : allVariants) {
            PaintingVariant art = (PaintingVariant)holder.m_203334_();
            if (art.m_218908_() != reference.m_218908_() || art.m_218909_() != reference.m_218909_()) continue;
            similar.add((Holder<PaintingVariant>)holder);
        }
        Furnish.debug("Found " + similar.size() + " painting variants similar to " + reference.toString());
        return similar;
    }
}

