/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.wouink.furnish.block.Plate;
import io.github.wouink.furnish.block.blockentity.PlateBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class PlateRenderer
implements BlockEntityRenderer<PlateBlockEntity> {
    private static final double ITEM_HEIGHT = 0.0625;
    private final ItemRenderer itemRenderer;

    public PlateRenderer(BlockEntityRendererProvider.Context ctx) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
    }

    public void render(PlateBlockEntity plate, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack = plate.getHeldItem();
        if (!stack.m_41619_()) {
            ms.m_85836_();
            BakedModel model = this.itemRenderer.m_174264_(stack, plate.m_58904_(), null, 0);
            Direction dir = ((Direction)plate.m_58900_().m_61143_((Property)Plate.f_54117_)).m_122424_();
            if (model.m_7539_()) {
                this.prepareRenderBlock(ms, dir);
            } else {
                this.prepareRenderItem(ms, dir);
            }
            this.itemRenderer.m_115143_(stack, ItemDisplayContext.FIXED, true, ms, buffer, light, overlay, model);
            ms.m_85849_();
        }
    }

    public void prepareRenderItem(PoseStack ms, Direction dir) {
        ms.m_85837_(0.5, 0.08, 0.5);
        float angle = -dir.m_122435_();
        ms.m_252781_(Axis.f_252436_.m_252977_(angle));
        ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        ms.m_85841_(0.6f, 0.6f, 0.6f);
    }

    public void prepareRenderBlock(PoseStack ms, Direction dir) {
        ms.m_85837_(0.5, 0.23, 0.5);
        float angle = -dir.m_122435_();
        ms.m_252781_(Axis.f_252436_.m_252977_(angle));
        ms.m_85841_(0.8f, 0.8f, 0.8f);
    }
}

