/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block.util;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape[] getMergedShapes(VoxelShape[] ... rotatedShapes) {
        VoxelShape[] ret = new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_()};
        for (int i = 0; i < rotatedShapes.length; ++i) {
            ret[0] = Shapes.m_83110_((VoxelShape)ret[0], (VoxelShape)rotatedShapes[i][0]);
            ret[1] = Shapes.m_83110_((VoxelShape)ret[1], (VoxelShape)rotatedShapes[i][1]);
            ret[2] = Shapes.m_83110_((VoxelShape)ret[2], (VoxelShape)rotatedShapes[i][2]);
            ret[3] = Shapes.m_83110_((VoxelShape)ret[3], (VoxelShape)rotatedShapes[i][3]);
        }
        ret[0] = ret[0].m_83296_();
        ret[1] = ret[1].m_83296_();
        ret[2] = ret[2].m_83296_();
        ret[3] = ret[3].m_83296_();
        return ret;
    }

    public static VoxelShape[] getRotatedShapes(VoxelShape source) {
        VoxelShape north = VoxelShapeHelper.rotate(source, Direction.NORTH);
        VoxelShape east = VoxelShapeHelper.rotate(source, Direction.EAST);
        VoxelShape south = VoxelShapeHelper.rotate(source, Direction.SOUTH);
        VoxelShape west = VoxelShapeHelper.rotate(source, Direction.WEST);
        return new VoxelShape[]{north, south, west, east};
    }

    public static VoxelShape rotate(VoxelShape source, Direction dir) {
        double[] adjustedValues = VoxelShapeHelper.adjustValues(dir, source.m_83288_(Direction.Axis.X), source.m_83288_(Direction.Axis.Z), source.m_83297_(Direction.Axis.X), source.m_83297_(Direction.Axis.Z));
        return Shapes.m_83048_((double)adjustedValues[0], (double)source.m_83288_(Direction.Axis.Y), (double)adjustedValues[1], (double)adjustedValues[2], (double)source.m_83297_(Direction.Axis.Y), (double)adjustedValues[3]);
    }

    public static double[] adjustValues(Direction dir, double v1, double v2, double v3, double v4) {
        switch (dir) {
            case WEST: {
                double vt1 = v1;
                v1 = 1.0 - v3;
                double vt2 = v2;
                v2 = 1.0 - v4;
                v3 = 1.0 - vt1;
                v4 = 1.0 - vt2;
                break;
            }
            case NORTH: {
                double vt3 = v1;
                v1 = v2;
                v2 = 1.0 - v3;
                v3 = v4;
                v4 = 1.0 - vt3;
                break;
            }
            case SOUTH: {
                double vt4 = v1;
                v1 = 1.0 - v4;
                double vt5 = v2;
                v2 = vt4;
                double vt6 = v3;
                v3 = 1.0 - vt5;
                v4 = vt6;
                break;
            }
        }
        return new double[]{v1, v2, v3, v4};
    }
}

