/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block.container;

import com.google.common.collect.Lists;
import io.github.wouink.furnish.recipe.FurnitureRecipe;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishRegistries;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FurnitureWorkbenchContainer
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<FurnitureRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            FurnitureWorkbenchContainer.this.m_6199_((Container)this);
            FurnitureWorkbenchContainer.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public FurnitureWorkbenchContainer(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public FurnitureWorkbenchContainer(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super((MenuType)FurnishRegistries.Furniture_Workbench_Container.get(), containerId);
        int i;
        this.access = access;
        this.level = playerInventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                FurnitureWorkbenchContainer.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ItemStack itemStack = FurnitureWorkbenchContainer.this.inputSlot.m_6201_(1);
                if (!itemStack.m_41619_()) {
                    FurnitureWorkbenchContainer.this.setupResultSlot();
                }
                access.m_39292_((level, blockPos) -> {
                    long l = level.m_46467_();
                    if (FurnitureWorkbenchContainer.this.lastSoundTime != l) {
                        SoundEvent soundEvent;
                        Item item = stack.m_41720_();
                        if (item instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)item;
                            soundEvent = blockItem.m_40614_().m_49962_(blockItem.m_40614_().m_49966_()).m_56775_();
                        } else {
                            soundEvent = SoundEvents.f_12630_;
                        }
                        SoundEvent sound = soundEvent;
                        level.m_5594_((Player)null, blockPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                        FurnitureWorkbenchContainer.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(FurnitureWorkbenchContainer.this.inputSlot.m_7993_());
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<FurnitureRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return FurnitureWorkbenchContainer.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)FurnishBlocks.Furniture_Workbench.get()));
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    public void m_6199_(Container container) {
        ItemStack itemStack = this.inputSlot.m_7993_();
        if (!itemStack.m_150930_(this.input.m_41720_())) {
            this.input = itemStack.m_41777_();
            this.setupRecipeList(container, itemStack);
        }
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)FurnishRegistries.Furniture_Recipe.get(), container, this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            FurnitureRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemStack = recipe.m_5874_(this.container, this.level.m_9598_());
            if (itemStack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)recipe);
                this.resultSlot.m_5852_(itemStack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)FurnishRegistries.Furniture_Workbench_Container.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (index == 1) {
                item.m_7836_(itemStack2, player.m_9236_(), player);
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (index == 0 ? !this.m_38903_(itemStack2, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)FurnishRegistries.Furniture_Recipe.get(), (Container)new SimpleContainer(new ItemStack[]{itemStack2}), this.level).isPresent() ? !this.m_38903_(itemStack2, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemStack2, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemStack2, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, this.container));
    }
}

